/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.runner;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.module.runner.Callback;

abstract class DefaultCallback<T>
implements Callback<T> {
    protected final Consumer<T> onSuccess;
    protected final Consumer<Map<MavenDependency, List<Exception>>> onError;
    protected final Runnable doFinally;

    protected DefaultCallback(Consumer<T> onSuccess, Consumer<Map<MavenDependency, List<Exception>>> onError, Runnable doFinally) {
        this.onSuccess = onSuccess;
        this.onError = onError;
        this.doFinally = doFinally;
    }

    @Override
    public void onSuccess(T result) {
        this.onSuccess.accept(result);
    }

    @Override
    public void onError(Map<MavenDependency, List<Exception>> errors) {
        this.onError.accept(errors);
    }

    @Override
    public void doFinally() {
        this.doFinally.run();
    }
}

