/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.runner;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.Callback;

public abstract class Builder<T> {
    protected Consumer<T> onSuccess = x -> {};
    protected Consumer<Map<MavenDependency, List<Exception>>> onError = x -> {};
    protected Runnable doFinally = () -> {};

    Builder() {
    }

    public Builder<T> onSuccess(Consumer<T> onSuccess) {
        this.onSuccess = onSuccess;
        return this;
    }

    public Builder<T> onError(Consumer<Map<MavenDependency, List<Exception>>> onError) {
        this.onError = onError;
        return this;
    }

    public Builder<T> onErrorLog() {
        this.onError = ArtifactResolvingRunnerFactory.ON_ERROR_LOG;
        return this;
    }

    public Builder<T> doFinally(Runnable doFinally) {
        this.doFinally = doFinally;
        return this;
    }

    public abstract Callback<T> build();
}

