/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.runner;

import jakarta.inject.Inject;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.DependencyResolutionConfiguration;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.runner.Builder;
import org.mule.tooling.core.module.runner.Callback;
import org.mule.tooling.core.module.runner.DependenciesCallback;
import org.mule.tooling.core.module.runner.ExtensionsCallback;
import org.mule.tooling.core.module.runner.IArtifactResolvingRunner;
import org.mule.tooling.core.module.runner.SingleExtensionCallback;
import org.mule.tooling.core.utils.EclipseContextHelper;

public class ArtifactResolvingRunnerFactory {
    @Inject
    private IArtifactResolvingRunner asyncInstance;
    public static final Consumer<Map<MavenDependency, List<Exception>>> ON_ERROR_LOG = errors -> errors.entrySet().forEach(entry -> {
        List exceptions = (List)entry.getValue();
        if (!exceptions.isEmpty()) {
            MavenDependency dep = (MavenDependency)entry.getKey();
            StringWriter errorsWriter = new StringWriter();
            exceptions.forEach(e -> e.printStackTrace(new PrintWriter(errorsWriter)));
            String errorsString = errorsWriter.toString();
            MuleCorePlugin.logError("The following exceptions were encountered while resolving dependency " + MavenCore.getCoords(dep) + ": " + errorsString, (Throwable)exceptions.get(0));
        }
    });

    public static IArtifactResolvingRunner asyncInstance() {
        return ArtifactResolvingRunnerFactory.factoryInstance()._asyncInstance();
    }

    private IArtifactResolvingRunner _asyncInstance() {
        return this.asyncInstance;
    }

    private static ArtifactResolvingRunnerFactory factoryInstance() {
        return EclipseContextHelper.createFromStudioContext(ArtifactResolvingRunnerFactory.class);
    }

    public static IArtifactResolvingRunner syncInstance() {
        return new SyncDecorator(ArtifactResolvingRunnerFactory.asyncInstance());
    }

    public static String getErrorsMessage(Map<MavenDependency, List<Exception>> errors) {
        StringBuilder resultBuilder = new StringBuilder();
        errors.entrySet().forEach(entry -> {
            List exceptions = (List)entry.getValue();
            if (!exceptions.isEmpty()) {
                resultBuilder.append("The following exceptions were encountered while resolving dependency " + MavenCore.getCoords((MavenDependency)entry.getKey()) + ": ");
                resultBuilder.append(exceptions.stream().map(e -> e.getMessage()).collect(Collectors.joining(", ")));
                resultBuilder.append(System.lineSeparator());
            }
        });
        return resultBuilder.toString();
    }

    private static class SyncDecorator
    implements IArtifactResolvingRunner {
        private IArtifactResolvingRunner decorated;

        public SyncDecorator(IArtifactResolvingRunner decorated) {
            this.decorated = decorated;
        }

        @Override
        public void runResolvingExtension(IMuleProject muleProject, MavenDependency dependency2, Callback<ExternalContributionMuleModule> callback, IProgressMonitor monitor) {
            Semaphore semaphore = new Semaphore(0);
            this.decorated.runResolvingExtension(muleProject, dependency2, this.runAndRelease(SingleExtensionCallback.copyFrom(callback), callback, semaphore), monitor);
            this.acquire(semaphore);
        }

        @Override
        public void runResolvingExtensions(IMuleProject muleProject, List<MavenDependency> dependencies, Callback<List<ExternalContributionMuleModule>> callback, IProgressMonitor monitor) {
            Semaphore semaphore = new Semaphore(0);
            this.decorated.runResolvingExtensions(muleProject, dependencies, this.runAndRelease(ExtensionsCallback.copyFrom(callback), callback, semaphore), monitor);
            this.acquire(semaphore);
        }

        @Override
        public void runResolvingDependencies(IMuleProject muleProject, List<MavenDependency> dependencies, Callback<Map<MavenDependency, File>> callback, IProgressMonitor monitor) {
            Semaphore semaphore = new Semaphore(0);
            this.decorated.runResolvingDependencies(muleProject, dependencies, this.runAndRelease(DependenciesCallback.copyFrom(callback), callback, semaphore), monitor);
            this.acquire(semaphore);
        }

        @Override
        public void runResolvingDependencies(IMuleProject muleProject, List<MavenDependency> dependencies, Callback<Map<MavenDependency, File>> callback, DependencyResolutionConfiguration configuration, IProgressMonitor monitor) {
            Semaphore semaphore = new Semaphore(0);
            this.decorated.runResolvingDependencies(muleProject, dependencies, this.runAndRelease(DependenciesCallback.copyFrom(callback), callback, semaphore), configuration, monitor);
            this.acquire(semaphore);
        }

        private <T> Callback<T> runAndRelease(Builder<T> callbackBuilder, Callback<T> callback, Semaphore semaphore) {
            return callbackBuilder.doFinally(() -> {
                try {
                    callback.doFinally();
                }
                finally {
                    semaphore.release();
                }
            }).build();
        }

        private void acquire(Semaphore semaphore) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                MuleCorePlugin.logWarning("Unexpected interrupted exception", e);
            }
        }
    }
}

