/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal.runner;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.core.m2.IDependencyResolver;
import org.mule.tooling.core.m2.Repository;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.ConsoleToMonitorTransferListener;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.internal.MuleMavenClientResolver;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.internal.runner.CompositeProgressMonitor;
import org.mule.tooling.core.module.runner.Callback;

abstract class Task<T> {
    static final Function<Consumer<DefaultRepositorySystemSession>, IDependencyResolver> DEFAULT_DEPENDENCY_RESOLVER_FACTORY = sessionConfigurator -> new MuleMavenClientResolver(MavenCore.getUserSettings(), MavenCore.newUserMavenConfiguration(MavenCore.getUserSettingsFile()), (Consumer<DefaultRepositorySystemSession>)sessionConfigurator);
    public static final int PROGRESS_SIZE = 10000000;
    protected final IMuleProject muleProject;
    protected final List<Repository> repositories;
    protected final List<MavenDependency> dependencies;
    protected final IProgressMonitor monitor;
    protected final CompositeProgressMonitor compositeMonitor;
    private final List<Task<T>> relatedTasks = new LinkedList<Task<T>>();
    private final Callback<T> callback;
    private final Function<Consumer<DefaultRepositorySystemSession>, IDependencyResolver> dependencyResolverFactory;
    private T successResult;
    private Map<MavenDependency, List<Exception>> errorResult;

    protected Task(IMuleProject project, List<MavenDependency> dependencies, Callback<T> callback, Function<Consumer<DefaultRepositorySystemSession>, IDependencyResolver> dependencyResolverFactory, IProgressMonitor monitor) {
        this.muleProject = project;
        this.dependencyResolverFactory = dependencyResolverFactory;
        this.repositories = this.muleProject.getProjectRepositories();
        this.dependencies = dependencies;
        this.callback = callback;
        this.monitor = monitor;
        this.compositeMonitor = new CompositeProgressMonitor();
        this.compositeMonitor.append(monitor);
    }

    public boolean run(IProgressMonitor monitor) {
        try {
            if (this.muleProject.isAccessible()) {
                this.compositeMonitor.append(monitor);
                try {
                    boolean bl = this.doRun(this.compositeMonitor);
                    return bl;
                }
                catch (Throwable e) {
                    this.onError(e instanceof Exception ? Task.mapDependenciesToException(this.getDependencies(), (Exception)e) : Collections.emptyMap());
                    throw e;
                }
            }
            this.onError(Collections.emptyMap());
            return false;
        }
        finally {
            this.done();
        }
    }

    public abstract boolean doRun(IProgressMonitor var1);

    public abstract String getDescription();

    static String getGav(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
    }

    private static boolean equals(String s1, String s2) {
        return s1 != null && s1.equals(s2) || s1 == null && s2 == null;
    }

    static boolean matches(Artifact artifact, MavenDependency dependency2) {
        return Task.equals(MavenCore.getGA(artifact), MavenUtils.getGA(dependency2));
    }

    static boolean matches(org.apache.maven.artifact.Artifact artifact, MavenDependency dependency2) {
        return Task.equals(MavenCore.getGA(artifact), MavenUtils.getGA(dependency2));
    }

    static Map<MavenDependency, List<Exception>> mapDependenciesToExceptions(Collection<MavenDependency> dependencies, List<Exception> exceptions) {
        return dependencies.stream().collect(Collectors.toMap(Function.identity(), x -> exceptions));
    }

    static Map<MavenDependency, List<Exception>> mapDependenciesToException(Collection<MavenDependency> dependencies, Exception e) {
        List<Exception> exceptions = Arrays.asList(e);
        return Task.mapDependenciesToExceptions(dependencies, exceptions);
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public List<MavenDependency> getDependencies() {
        return this.dependencies;
    }

    public List<Repository> getRepositories() {
        return this.repositories;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void append(Task<T> task) {
        this.relatedTasks.add(task);
    }

    protected void onSuccess(T successResult) {
        this.successResult = successResult;
    }

    protected void onError(Map<MavenDependency, List<Exception>> errorResult) {
        this.errorResult = errorResult;
    }

    protected void done() {
        try {
            Optional.ofNullable(this.successResult).ifPresent(result -> this.callback.onSuccess(result));
            Optional.ofNullable(this.errorResult).ifPresent(errors -> this.callback.onError((Map<MavenDependency, List<Exception>>)errors));
        }
        finally {
            this.callback.doFinally();
        }
    }

    public List<Task<T>> getRelatedTasks() {
        return this.relatedTasks;
    }

    public IDependencyResolver getDependencyResolver(IProgressMonitor monitor) {
        return this.dependencyResolverFactory.apply(session -> this.configureSession((DefaultRepositorySystemSession)session, monitor));
    }

    protected void configureSession(DefaultRepositorySystemSession session, IProgressMonitor monitor) {
        session.setTransferListener((TransferListener)new ConsoleToMonitorTransferListener(monitor));
        DependencySelector dependencySelector = session.getDependencySelector();
        session.setDependencySelector(this.getDependencySelector(dependencySelector));
    }

    protected DependencySelector getDependencySelector(DependencySelector dependencySelector) {
        return dependencySelector;
    }

    public T getSuccessResult() {
        return this.successResult;
    }

    public Map<MavenDependency, List<Exception>> getErrorResult() {
        return this.errorResult;
    }

    public String toString() {
        return "Task [muleProject=" + String.valueOf(this.muleProject) + ", dependencies=" + String.valueOf(this.dependencies) + "]";
    }
}

