/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal.runner;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.core.m2.IDependencyResolver;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.internal.runner.DownloadTask;
import org.mule.tooling.core.module.runner.Callback;
import org.mule.tooling.core.module.runner.ExtensionsCallback;

public class SingleDownloadTask
extends DownloadTask {
    private MavenDependency dependency;

    public SingleDownloadTask(IMuleProject project, MavenDependency dependency2, Callback<ExternalContributionMuleModule> callback, IProgressMonitor monitor) {
        super(project, Arrays.asList(dependency2), ExtensionsCallback.builder().onSuccess(modules -> SingleDownloadTask.singleSuccess(dependency2, modules, callback)).onError((Map<MavenDependency, List<Exception>> x) -> callback.onError((Map<MavenDependency, List<Exception>>)x)).doFinally(callback::doFinally).build(), (Function<Consumer<DefaultRepositorySystemSession>, IDependencyResolver>)DEFAULT_DEPENDENCY_RESOLVER_FACTORY, monitor);
        this.dependency = dependency2;
    }

    private static void singleSuccess(MavenDependency dependency2, List<ExternalContributionMuleModule> modules, Callback<ExternalContributionMuleModule> callback) {
        String gav = MavenUtils.getGAV(dependency2);
        Optional<ExternalContributionMuleModule> optModule = modules.stream().filter(module -> module.getId().equals(gav)).findFirst();
        if (optModule.isPresent()) {
            callback.onSuccess(optModule.get());
        } else {
            String actualResultDescription = modules.isEmpty() ? "empty" : (modules.size() == 1 ? modules.get(0).getName() + " " + modules.get(0).getVersion() : "the following resolved modules " + modules.stream().map(module -> module.getName() + " " + module.getVersion()).collect(Collectors.joining(", ")));
            callback.onError(SingleDownloadTask.mapDependenciesToException(Arrays.asList(dependency2), new RuntimeException("Requested to resolve module " + gav + ", but the result was " + actualResultDescription)));
        }
    }

    @Override
    public String getDescription() {
        return "Initializing " + this.muleProject.getName() + " project module " + MavenCore.getCoords(this.dependency);
    }
}

