/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal.runner;

import com.google.common.base.Throwables;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.core.m2.DependencyResolutionConfiguration;
import org.mule.tooling.core.m2.DependencyResolutionException;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.DependencyResolutionResult;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.internal.runner.Task;
import org.mule.tooling.core.module.runner.Callback;

final class ResolveTask
extends Task<Map<MavenDependency, File>> {
    private DependencyResolutionConfiguration configuration;

    public ResolveTask(IMuleProject project, List<MavenDependency> dependencies, Callback<Map<MavenDependency, File>> callback, IProgressMonitor monitor) {
        this(project, dependencies, callback, DependencyResolutionConfiguration.createDefault(), monitor);
    }

    public ResolveTask(IMuleProject project, List<MavenDependency> dependencies, Callback<Map<MavenDependency, File>> callback, DependencyResolutionConfiguration configuration, IProgressMonitor monitor) {
        super(project, dependencies, callback, configuration.getResolverFactory().orElse(DEFAULT_DEPENDENCY_RESOLVER_FACTORY), monitor);
        this.configuration = configuration;
    }

    @Override
    public String getDescription() {
        return "Downloading " + this.muleProject.getName() + " project dependencies: " + this.dependencies.stream().map(MavenCore::getCoords).collect(Collectors.joining(", "));
    }

    @Override
    public boolean doRun(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Resolving dependencies", 10000000);
            List<DependencyResolutionResult> results = this.getDependencyResolver(monitor).resolveDependencies(this.muleProject, this.dependencies, this.configuration, monitor);
            HashMap<MavenDependency, File> resolvedArtifacts = new HashMap<MavenDependency, File>();
            HashMap<MavenDependency, List<Exception>> failedArtifacts = new HashMap<MavenDependency, List<Exception>>();
            boolean jobCancelled = false;
            for (DependencyResolutionResult result : results) {
                MavenDependency key = result.getDependency();
                if (result.isSuccessful()) {
                    File file = result.getResultFile();
                    resolvedArtifacts.put(key, file);
                    continue;
                }
                List<Exception> exceptions = result.getExceptions();
                boolean cancelled = exceptions.stream().flatMap(exception -> Throwables.getCausalChain((Throwable)exception).stream()).anyMatch(TransferCancelledException.class::isInstance);
                if (cancelled) {
                    jobCancelled = true;
                    resolvedArtifacts.put(key, null);
                    continue;
                }
                failedArtifacts.put(key, result.getExceptions());
            }
            if (jobCancelled || failedArtifacts.isEmpty()) {
                this.onSuccess(resolvedArtifacts);
                return true;
            }
            if (!resolvedArtifacts.isEmpty()) {
                this.onSuccess(resolvedArtifacts);
            }
            this.onError(failedArtifacts);
            return false;
        }
        catch (DependencyResolutionException e) {
            this.onError(Task.mapDependenciesToException(this.dependencies, e));
            return false;
        }
        finally {
            monitor.done();
        }
    }
}

