/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal.runner;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.internal.runner.DownloadTask;
import org.mule.tooling.core.module.internal.runner.Task;
import org.mule.tooling.core.module.runner.Callback;
import org.mule.tooling.utils.collection.ListView;

class PartitionResultsMonitor {
    private final int partitionSize;
    private final List<DownloadTask> completedTasks = new LinkedList<DownloadTask>();
    private final Callback<List<ExternalContributionMuleModule>> callback;

    public PartitionResultsMonitor(int partitionSize, Callback<List<ExternalContributionMuleModule>> callback) {
        this.partitionSize = partitionSize;
        this.callback = callback;
    }

    public void taskDone(DownloadTask task) {
        this.completedTasks.add(task);
        if (this.completedTasks.size() == this.partitionSize) {
            try {
                this.runSuccessCallback();
            }
            finally {
                try {
                    this.runErrorCallback();
                }
                finally {
                    this.callback.doFinally();
                }
            }
        }
    }

    private void runErrorCallback() {
        HashMap<MavenDependency, List<Exception>> allErrorsMap = new HashMap<MavenDependency, List<Exception>>();
        this.completedTasks.stream().map(Task::getErrorResult).filter(Objects::nonNull).forEach(allErrorsMap::putAll);
        if (!allErrorsMap.isEmpty()) {
            this.callback.onError(allErrorsMap);
        }
    }

    private void runSuccessCallback() {
        Optional<List> successResults = this.completedTasks.stream().map(Task::getSuccessResult).filter(Objects::nonNull).reduce(ListView::of);
        successResults.ifPresent(results -> this.callback.onSuccess((List<ExternalContributionMuleModule>)results));
    }
}

