/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal.runner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.DependencyResolutionException;
import org.mule.tooling.core.m2.IDependencyResolver;
import org.mule.tooling.core.m2.Repository;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.DependencyResolutionResult;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.IModuleContributionManager;
import org.mule.tooling.core.module.internal.runner.Task;
import org.mule.tooling.core.module.runner.Callback;
import org.mule.tooling.model.project.MuleExtension;

public class DownloadTask
extends Task<List<ExternalContributionMuleModule>> {
    public DownloadTask(IMuleProject project, List<MavenDependency> dependencies, Callback<List<ExternalContributionMuleModule>> callback, IProgressMonitor monitor) {
        this(project, dependencies, callback, (Function<Consumer<DefaultRepositorySystemSession>, IDependencyResolver>)DEFAULT_DEPENDENCY_RESOLVER_FACTORY, monitor);
    }

    public DownloadTask(IMuleProject project, List<MavenDependency> dependencies, Callback<List<ExternalContributionMuleModule>> callback, Function<Consumer<DefaultRepositorySystemSession>, IDependencyResolver> dependencyResolverFactory, IProgressMonitor monitor) {
        super(project, dependencies, callback, dependencyResolverFactory, monitor);
    }

    @Override
    public String getDescription() {
        return "Initializing " + this.muleProject.getName() + " project modules " + this.dependencies.stream().map(MavenCore::getCoords).collect(Collectors.joining(", "));
    }

    @Override
    public boolean doRun(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Resolving modules", (int)10000000);
        List<MuleExtension> availableModules = this.muleProject.getDeclaredExtensions();
        HashSet<MavenDependency> dependenciesToResolve = new HashSet<MavenDependency>(this.dependencies.size() + availableModules.size());
        HashSet<ExternalContributionMuleModule> resolvedModules = new HashSet<ExternalContributionMuleModule>();
        IModuleContributionManager moduleContributionManager = MuleCorePlugin.getModuleContributionManager();
        for (MavenDependency mavenDependency : this.dependencies) {
            Optional<ExternalContributionMuleModule> externalModule = moduleContributionManager.getExternalModule(this.muleProject.getServerDefinition(), MavenCore.getCoords(mavenDependency));
            if (externalModule.isPresent()) {
                resolvedModules.add(externalModule.get());
                continue;
            }
            dependenciesToResolve.add(mavenDependency);
        }
        List<Repository> projectRepos = this.muleProject.getProjectRepositories();
        try {
            List dependenciesToReportError;
            int stepSize;
            List<DependencyResolutionResult> results = this.getDependencyResolver((IProgressMonitor)subMonitor).resolvePluginDependencies(this.muleProject, dependenciesToResolve, (IProgressMonitor)subMonitor.split(3333333));
            LinkedList<DependencyResolutionResult> successResults = new LinkedList<DependencyResolutionResult>();
            LinkedList<DependencyResolutionResult> failureResults = new LinkedList<DependencyResolutionResult>();
            subMonitor.beginTask("Loading extension models", 3333333);
            for (DependencyResolutionResult result2 : results) {
                stepSize = 3333333 / results.size();
                if (result2.isSuccessful()) {
                    successResults.add(result2);
                } else {
                    failureResults.add(result2);
                }
                subMonitor.split(stepSize);
            }
            subMonitor.beginTask("Initializing modules editors", 3333333);
            for (DependencyResolutionResult result2 : successResults) {
                stepSize = 3333333 / successResults.size();
                ExternalContributionMuleModule module = null;
                try {
                    module = moduleContributionManager.getExternalModule(this.muleProject.getServerDefinition(), result2.getDependency(), projectRepos);
                }
                catch (Exception e) {
                    result2.addException(e);
                    failureResults.add(result2);
                }
                if (module != null) {
                    resolvedModules.add(module);
                } else {
                    failureResults.add(result2);
                }
                subMonitor.split(stepSize);
            }
            HashMap<MavenDependency, List<Exception>> exceptionsMap = new HashMap<MavenDependency, List<Exception>>(failureResults.size());
            failureResults.stream().filter(result -> !result.isSuccessful()).forEach(result -> exceptionsMap.put(result.getDependency(), result.getExceptions()));
            boolean result3 = true;
            if (!exceptionsMap.isEmpty()) {
                this.onError(exceptionsMap);
                result3 &= false;
            }
            if (!resolvedModules.isEmpty()) {
                this.onSuccess(new ArrayList(resolvedModules));
                result3 &= true;
            } else if (exceptionsMap.isEmpty() && !(dependenciesToReportError = this.dependencies).isEmpty()) {
                this.onError(DownloadTask.mapDependenciesToException(dependenciesToReportError, new IllegalStateException("no exceptions recorded but no modules resolved either")));
                result3 &= false;
            }
            boolean bl = result3;
            return bl;
        }
        catch (DependencyResolutionException e) {
            if (e.getCause() instanceof AbstractArtifactResolutionException) {
                AbstractArtifactResolutionException artifactResolutionException = (AbstractArtifactResolutionException)e.getCause();
                Optional<MavenDependency> dependency2 = this.dependencies.stream().filter(dep -> DownloadTask.matches(artifactResolutionException.getArtifact(), dep)).findFirst();
                if (dependency2.isPresent()) {
                    this.onError(DownloadTask.mapDependenciesToException(Arrays.asList(dependency2.get()), e));
                } else {
                    this.onError(DownloadTask.mapDependenciesToException(dependenciesToResolve, e));
                }
            } else {
                this.onError(DownloadTask.mapDependenciesToException(dependenciesToResolve, e));
            }
            return false;
        }
        finally {
            subMonitor.done();
        }
    }

    @Override
    protected DependencySelector getDependencySelector(DependencySelector baseSelector) {
        return new AndDependencySelector(new DependencySelector[]{baseSelector, new ScopeDependencySelector(new String[]{"test"})});
    }
}

