/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal.runner;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.core.module.runner.CancellingProgressMonitor;

public class CompositeProgressMonitor
implements IProgressMonitor {
    private List<Consumer<IProgressMonitor>> actions;
    private int currentWorked = 0;
    private List<IProgressMonitor> monitors = Collections.synchronizedList(new LinkedList());

    public CompositeProgressMonitor() {
        this.actions = Collections.synchronizedList(new LinkedList());
    }

    public void append(IProgressMonitor monitor) {
        if (!this.isCanceled()) {
            this.monitors.add(monitor);
            if (monitor instanceof CancellingProgressMonitor) {
                CancellingProgressMonitor cancellingProgressMonitor = (CancellingProgressMonitor)monitor;
                cancellingProgressMonitor.addCancelListener(b -> {
                    if (b.booleanValue()) {
                        this.monitors.stream().filter(m -> m != cancellingProgressMonitor).forEach(m -> m.setCanceled(b.booleanValue()));
                    }
                });
            }
            this.actions.forEach(a -> a.accept(monitor));
            monitor.worked(this.currentWorked);
        } else {
            monitor.setCanceled(true);
        }
    }

    private void dispatch(Consumer<IProgressMonitor> consumer, boolean recordAction) {
        if (recordAction) {
            this.actions.add(consumer);
        }
        this.monitors.forEach(consumer);
    }

    private void dispatch(Consumer<IProgressMonitor> consumer) {
        this.dispatch(consumer, true);
    }

    public void beginTask(String name, int totalWork) {
        this.dispatch(m -> m.beginTask(name, totalWork));
    }

    public void done() {
        this.dispatch(m -> m.done());
    }

    public void internalWorked(double work) {
        this.dispatch(m -> m.internalWorked(work));
    }

    public boolean isCanceled() {
        boolean cancelled = this.monitors.stream().anyMatch(IProgressMonitor::isCanceled);
        if (cancelled) {
            this.monitors.stream().filter(m -> !m.isCanceled()).forEach(m -> m.setCanceled(true));
        }
        return cancelled;
    }

    public void setCanceled(boolean value) {
        this.dispatch(m -> m.setCanceled(value));
    }

    public void setTaskName(String name) {
        this.dispatch(m -> m.setTaskName(name));
    }

    public void subTask(String name) {
        this.dispatch(m -> m.subTask(name));
    }

    public void worked(int work) {
        this.currentWorked += work;
        this.dispatch(m -> m.worked(work), false);
    }
}

