/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal.runner;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.DependencyResolutionConfiguration;
import org.mule.tooling.core.m2.Repository;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.internal.runner.DownloadTask;
import org.mule.tooling.core.module.internal.runner.PartitionResultsMonitor;
import org.mule.tooling.core.module.internal.runner.ResolveTask;
import org.mule.tooling.core.module.internal.runner.SingleDownloadTask;
import org.mule.tooling.core.module.internal.runner.Task;
import org.mule.tooling.core.module.runner.Callback;
import org.mule.tooling.core.module.runner.IArtifactResolvingRunner;
import org.mule.tooling.core.module.runner.StateCheckingRunnerDecorator;
import org.mule.tooling.core.utils.JobUtils;

public class ArtifactResolvingRunner
implements IArtifactResolvingRunner {
    private static final String PROP_RESOLVER_THREAD_COUNT = "org.mule.tooling.resolver.threadCount";
    public static final int RESOLVER_THREAD_COUNT = Integer.parseInt(System.getProperty("org.mule.tooling.resolver.threadCount", "8"));
    public static final JobGroup resolutionJobGroup = JobUtils.createJobGroup("Artifact resolution", RESOLVER_THREAD_COUNT);
    private final Object tasksLock = new Object();
    private final List<Task<?>> runningTasks = new LinkedList();

    public static IArtifactResolvingRunner instance() {
        return Singleton.instance;
    }

    @Override
    public void runResolvingExtension(IMuleProject muleProject, MavenDependency dependency2, Callback<ExternalContributionMuleModule> callback, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        String mavenCoords = MavenCore.getCoords(dependency2);
        Optional<ExternalContributionMuleModule> externalModule = MuleCorePlugin.getModuleContributionManager().getExternalModule(muleProject.getServerDefinition(), mavenCoords);
        if (externalModule.isPresent()) {
            this.runWithFinally(callback, () -> callback.onSuccess((ExternalContributionMuleModule)externalModule.get()));
        } else {
            SingleDownloadTask task = new SingleDownloadTask(muleProject, dependency2, callback, (IProgressMonitor)subMonitor);
            this.scheduleOrAppend(muleProject, task, Optional.empty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runResolvingExtensions(IMuleProject muleProject, List<MavenDependency> dependencies, Callback<List<ExternalContributionMuleModule>> callback, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        Object object = this.tasksLock;
        synchronized (object) {
            Optional<Task<?>> bestMatchingTask = this.findBestMatchingTask(dependencies, muleProject.getProjectRepositories());
            if (bestMatchingTask.isPresent()) {
                this.partitionAndSchedule(muleProject, dependencies, callback, (IProgressMonitor)subMonitor, bestMatchingTask);
            } else {
                DownloadTask task = new DownloadTask(muleProject, dependencies, callback, (IProgressMonitor)subMonitor);
                this.schedule(task, Optional.empty());
            }
        }
    }

    private void partitionAndSchedule(IMuleProject muleProject, List<MavenDependency> dependencies, Callback<List<ExternalContributionMuleModule>> callback, IProgressMonitor monitor, Optional<Task<?>> bestMatchingTask) {
        ArrayList<MavenDependency> dependenciesToBeScheduled = new ArrayList<MavenDependency>(dependencies);
        HashMap partitions = new HashMap();
        while (bestMatchingTask.isPresent()) {
            Task<?> task = bestMatchingTask.get();
            List<MavenDependency> inProgressDependencies = task.getDependencies();
            Collection depsDependentOnTask = CollectionUtils.intersection(inProgressDependencies, dependenciesToBeScheduled);
            dependenciesToBeScheduled.removeAll(depsDependentOnTask);
            partitions.put(task, new ArrayList(depsDependentOnTask));
            bestMatchingTask = this.findBestMatchingTask(dependenciesToBeScheduled, muleProject.getProjectRepositories());
        }
        int partitionsCount = partitions.size() + (dependenciesToBeScheduled.isEmpty() ? 0 : 1);
        final PartitionResultsMonitor partitionsMonitor = new PartitionResultsMonitor(partitionsCount, callback);
        for (Map.Entry partitionEntry : partitions.entrySet()) {
            DownloadTask dependentTask = new DownloadTask(muleProject, (List)partitionEntry.getValue(), callback, monitor){

                @Override
                protected void done() {
                    partitionsMonitor.taskDone(this);
                }
            };
            ((Task)partitionEntry.getKey()).append(dependentTask);
        }
        if (!dependenciesToBeScheduled.isEmpty()) {
            DownloadTask notInProgressTask = new DownloadTask(muleProject, dependenciesToBeScheduled, callback, monitor){

                @Override
                protected void done() {
                    partitionsMonitor.taskDone(this);
                }
            };
            this.schedule(notInProgressTask, Optional.empty());
        }
    }

    private Optional<Task<?>> findBestMatchingTask(List<MavenDependency> dependencies, List<Repository> repositories) {
        Optional<Task<?>> bestMatchingTask = this.runningTasks.stream().filter(task -> repositories.containsAll(task.getRepositories())).filter(task -> !this.intersectingDeps((Task<?>)task, dependencies).isEmpty()).sorted((t1, t2) -> this.intersectingDeps((Task<?>)t1, dependencies).size() - this.intersectingDeps((Task<?>)t2, dependencies).size()).findFirst();
        return bestMatchingTask;
    }

    private Collection<MavenDependency> intersectingDeps(Task<?> task, List<MavenDependency> dependencies) {
        return CollectionUtils.intersection(task.getDependencies(), dependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void scheduleOrAppend(IMuleProject muleProject, Task<T> task, Optional<ISchedulingRule> rule) {
        boolean schedule = false;
        Object object = this.tasksLock;
        synchronized (object) {
            Task<T> runningTask = this.getRunningTask(task);
            boolean bl = schedule = runningTask == null;
            if (!schedule) {
                runningTask.append(task);
            }
        }
        if (schedule) {
            this.schedule(task, rule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void schedule(final Task<T> task, Optional<ISchedulingRule> rule) {
        ArtifactJob<T> job = new ArtifactJob<T>(task);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ArtifactResolvingRunner.this.taskJobFinished(task, event);
            }
        });
        rule.ifPresent(arg_0 -> job.setRule(arg_0));
        job.setJobGroup(resolutionJobGroup);
        Object object = this.tasksLock;
        synchronized (object) {
            this.runningTasks.add(task);
        }
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void taskJobFinished(Task<T> task, IJobChangeEvent event) {
        Object object = this.tasksLock;
        synchronized (object) {
            this.runningTasks.remove(task);
        }
        task.getRelatedTasks().forEach(relatedTask -> this.schedule((Task)relatedTask, Optional.empty()));
    }

    private <T extends Task<?>> T getRunningTask(T task) {
        return (T)((Task)this.runningTasks.stream().filter(runningTask -> this.matches((Task<?>)runningTask, task)).findFirst().orElse(null));
    }

    private boolean matches(Task<?> runningTask, Task<?> task) {
        if (runningTask.getClass().equals(task.getClass()) && task.getRepositories().equals(runningTask.getRepositories())) {
            return runningTask.getDependencies().equals(task.getDependencies());
        }
        return false;
    }

    @Override
    public void runResolvingDependencies(IMuleProject muleProject, List<MavenDependency> dependencies, Callback<Map<MavenDependency, File>> callback, DependencyResolutionConfiguration configuration, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        if (dependencies.isEmpty()) {
            this.runWithFinally(callback, () -> callback.onSuccess(Collections.emptyMap()));
        } else {
            ResolveTask task = new ResolveTask(muleProject, dependencies, callback, configuration, (IProgressMonitor)subMonitor);
            this.scheduleOrAppend(muleProject, task, Optional.empty());
        }
    }

    @Override
    public void runResolvingDependencies(IMuleProject muleProject, List<MavenDependency> dependencies, Callback<Map<MavenDependency, File>> callback, IProgressMonitor monitor) {
        this.runResolvingDependencies(muleProject, dependencies, callback, DependencyResolutionConfiguration.createDefault(), monitor);
    }

    private void runWithFinally(Callback<?> callback, Runnable runnable) {
        try {
            runnable.run();
        }
        finally {
            callback.doFinally();
        }
    }

    private static final class ArtifactJob<T>
    extends Job {
        private final Task<T> task;

        public ArtifactJob(Task<T> task) {
            super(task.getDescription());
            this.task = task;
        }

        protected IStatus run(IProgressMonitor monitor) {
            boolean result = this.task.run(monitor);
            return result ? Status.OK_STATUS : Status.CANCEL_STATUS;
        }
    }

    private static class Singleton {
        private static final IArtifactResolvingRunner instance = new StateCheckingRunnerDecorator(new ArtifactResolvingRunner());

        private Singleton() {
        }
    }
}

