/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.core.module.ModuleInitializationException;
import org.mule.tooling.core.module.MuleModule;
import org.mule.tooling.core.module.internal.IModuleHandler;
import org.mule.tooling.core.module.templates.TemplateManager;
import org.mule.tooling.core.xml.XmlFactoryUtils;
import org.mule.tooling.internal.core.module.BundleBasedArtifact;
import org.mule.tooling.model.module.NodeDefinition;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class SingleModuleHandler
implements IModuleHandler<MuleModule> {
    public static final String SINGLE_HANDLER_ID = "id";
    private MuleModule muleModule;
    private DocumentBuilder documentBuilder;

    public SingleModuleHandler(IConfigurationElement element, String id) throws ModuleInitializationException {
        this.init(element, id);
    }

    private void init(IConfigurationElement element, String id) throws ModuleInitializationException {
        String contributorName = element.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)contributorName);
        BundleBasedArtifact muleArtifact = new BundleBasedArtifact(bundle);
        try {
            String path = element.getAttribute("path");
            URL resource = bundle.getResource(path);
            if (resource == null) {
                throw new IllegalArgumentException("can not find resource with path:" + path + " in bundle " + String.valueOf(bundle));
            }
            Throwable throwable = null;
            Object var9_11 = null;
            try (InputStream stream = resource.openStream();){
                if (this.documentBuilder == null) {
                    this.documentBuilder = XmlFactoryUtils.createSecureDocumentBuilder();
                }
                Document parse = TemplateManager.process(this.documentBuilder.parse(stream));
                this.muleModule = new MuleModule(id);
                this.muleModule.initialize(muleArtifact, parse);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ModuleInitializationException(id, e);
        }
    }

    @Override
    public List<MuleModule> getModules() {
        List<MuleModule> modules = this.muleModule != null ? Arrays.asList(this.muleModule) : Collections.emptyList();
        return modules;
    }

    @Override
    public void registerModeOperationOverride(NodeDefinition nodeDefinition, String operationName) {
    }

    @Override
    public String getUniqueIdentifier() {
        return this.muleModule.getId();
    }
}

