/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal;

import java.text.MessageFormat;
import java.util.List;
import java.util.function.Function;
import org.eclipse.core.runtime.IConfigurationElement;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.module.MuleModule;
import org.mule.tooling.core.module.internal.GroupModuleHandler;
import org.mule.tooling.core.module.internal.IModuleHandler;

public class ReferenceModuleHandler
extends GroupModuleHandler<MuleModule> {
    public static final String GROUP_REFERENCE_CONTRIBUTION_ID = "contributionset";
    public static final String SIMPLE_REFERENCE_CONTRIBUTION_ID = "contribution";
    private static final String MODULE_HANDLER_REFERENCE_ID = "reference-id";

    public ReferenceModuleHandler(Function<String, IModuleHandler<MuleModule>> moduleResolverFunction, String uniqueIdentifier, List<IConfigurationElement> elements) {
        super(uniqueIdentifier);
        this.init(elements, moduleResolverFunction);
    }

    protected void init(List<IConfigurationElement> configurationElements, Function<String, IModuleHandler<MuleModule>> moduleResolverFunction) {
        for (IConfigurationElement element : configurationElements) {
            this.initElement(element, moduleResolverFunction);
        }
    }

    public void initElement(IConfigurationElement element, Function<String, IModuleHandler<MuleModule>> moduleResolverFunction) {
        String contributionType = element.getName();
        if (contributionType.equals(GROUP_REFERENCE_CONTRIBUTION_ID)) {
            String moduleHandlerId = element.getAttribute(MODULE_HANDLER_REFERENCE_ID);
            IModuleHandler<MuleModule> referenceModuleHandler = moduleResolverFunction.apply(moduleHandlerId);
            if (referenceModuleHandler != null) {
                this.addHandler(referenceModuleHandler);
            } else {
                MuleCorePlugin.logWarning(MessageFormat.format("A module handler by the id \"{0}\" (required by the group with id: \"{1}\") was not found", moduleHandlerId, this.getUniqueIdentifier()));
            }
        } else if (contributionType.equals(SIMPLE_REFERENCE_CONTRIBUTION_ID)) {
            String moduleHandlerId = element.getAttribute(MODULE_HANDLER_REFERENCE_ID);
            IModuleHandler<MuleModule> moduleHandler = moduleResolverFunction.apply(moduleHandlerId);
            if (moduleHandler != null) {
                this.addHandler(moduleHandler);
            } else {
                MuleCorePlugin.logWarning(MessageFormat.format("A module handler with the id \"{0}\" (required by the reference with id: \"{1}\") was not found", moduleHandlerId, this.getUniqueIdentifier()));
            }
        }
    }

    public String toString() {
        return "ReferenceModuleHandler [modules=" + String.valueOf(this.getHandlers()) + ", uniqueIdentifier=" + this.getUniqueIdentifier() + "]";
    }
}

