/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.xml.namespace.QName;
import org.mule.tooling.core.module.MuleModule;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;

public class MuleModuleManagerCache {
    private volatile Map<String, NestedDefinition> nestedModulesIndex;
    private volatile Collection<NestedDefinition> sortedNestedDefinitions;
    private final Map<String, Map<QName, ArrayList<NodeDefinition>>> qnameMappingsCache = new ConcurrentHashMap<String, Map<QName, ArrayList<NodeDefinition>>>();
    private final Map<String, List<NodeDefinition>> sortedNodeDefinitionsCache = new ConcurrentHashMap<String, List<NodeDefinition>>();
    private final Map<String, Collection<MuleModule>> modulesPerVersionCache = new ConcurrentHashMap<String, Collection<MuleModule>>();
    private final Map<String, List<GlobalDefinition>> sortedGlobalDefinitionsCache = new ConcurrentHashMap<String, List<GlobalDefinition>>();
    private final Map<String, List<NestedDefinition>> allowedChildrenCache = new ConcurrentHashMap<String, List<NestedDefinition>>();
    private final Map<String, List<GlobalDefinition>> globalSubtypesCache = new ConcurrentHashMap<String, List<GlobalDefinition>>();
    private final Map<Stereotype, List<NestedDefinition>> allowedChildrenCacheByStereotype = new ConcurrentHashMap<Stereotype, List<NestedDefinition>>();

    public void clear() {
        this.nestedModulesIndex = null;
        this.sortedNestedDefinitions = null;
        this.qnameMappingsCache.clear();
        this.modulesPerVersionCache.clear();
        this.sortedNodeDefinitionsCache.clear();
        this.sortedGlobalDefinitionsCache.clear();
        this.allowedChildrenCache.clear();
        this.globalSubtypesCache.clear();
        this.allowedChildrenCacheByStereotype.clear();
    }

    public Collection<MuleModule> getModules(String versionToCheck, Supplier<Collection<MuleModule>> ifAbsent) {
        return this.modulesPerVersionCache.computeIfAbsent(versionToCheck, key -> (Collection)ifAbsent.get());
    }

    public List<NodeDefinition> getDefinitions(String versionToCheck, Supplier<List<NodeDefinition>> ifAbsent) {
        return this.sortedNodeDefinitionsCache.computeIfAbsent(versionToCheck, key -> (List)ifAbsent.get());
    }

    public List<NestedDefinition> getAllowedChildrenOfDefinition(String id, Supplier<List<NestedDefinition>> ifAbsent) {
        return this.allowedChildrenCache.computeIfAbsent(id, key -> (List)ifAbsent.get());
    }

    public List<NestedDefinition> getAllowedChildrenOfDefinition(Stereotype id, Supplier<List<NestedDefinition>> ifAbsent) {
        return this.allowedChildrenCacheByStereotype.computeIfAbsent(id, key -> (List)ifAbsent.get());
    }

    public Map<QName, ArrayList<NodeDefinition>> getOverrides(String versionToCheck, Supplier<Map<QName, ArrayList<NodeDefinition>>> ifAbsent) {
        return this.qnameMappingsCache.computeIfAbsent(versionToCheck, key -> (Map)ifAbsent.get());
    }

    public List<GlobalDefinition> getGlobalDefinitions(String versionToCheck, Supplier<List<GlobalDefinition>> ifAbsent) {
        return this.sortedGlobalDefinitionsCache.computeIfAbsent(versionToCheck, key -> (List)ifAbsent.get());
    }

    public boolean isNestedDefinitionsCacheEmpty() {
        return this.nestedModulesIndex == null;
    }

    public List<GlobalDefinition> getGlobalSubtypes(String id, Supplier<List<GlobalDefinition>> ifAbsent) {
        return this.globalSubtypesCache.computeIfAbsent(id, key -> (List)ifAbsent.get());
    }

    public void setNestedDefinitionsCache(Map<String, NestedDefinition> _nestedModulesIndex) {
        ArrayList<NestedDefinition> nestedDefinitions = new ArrayList<NestedDefinition>(_nestedModulesIndex.values());
        Collections.sort(nestedDefinitions);
        this.nestedModulesIndex = _nestedModulesIndex;
        this.sortedNestedDefinitions = nestedDefinitions;
    }

    public boolean containsNestedDefinition(String id) {
        return this.nestedModulesIndex.containsKey(id);
    }

    public NestedDefinition getNestedDefinition(String id) {
        return this.nestedModulesIndex.get(id);
    }

    public Collection<NestedDefinition> getSortedNestedDefinitions() {
        return this.sortedNestedDefinitions;
    }
}

