/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal;

import java.util.List;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.MuleModule;
import org.mule.tooling.core.module.internal.BaseModuleManager;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.utils.collection.ListView;

public class MuleModuleManager
extends BaseModuleManager {
    private final List<MuleModule> allModules;
    private final List<MuleModule> coreModules;
    private final List<ExternalContributionMuleModule> externalModules;
    private String versionWithEeSign;

    public MuleModuleManager(List<MuleModule> coreModules, List<ExternalContributionMuleModule> externalModules, String versionWithEeSign) {
        this.coreModules = coreModules;
        this.versionWithEeSign = versionWithEeSign;
        this.allModules = ListView.of(coreModules, externalModules);
        this.externalModules = externalModules;
    }

    @Override
    public List<MuleModule> getModules() {
        return this.allModules;
    }

    @Override
    public List<MuleModule> getCoreModules() {
        return this.coreModules;
    }

    @Override
    public List<ExternalContributionMuleModule> getExternalModules() {
        return this.externalModules;
    }

    @Override
    public boolean containsExtension(MuleExtension extension) {
        return this.externalModules.stream().map(CoreUtils::getMuleExtensionFromModule).anyMatch(extension::equals);
    }

    @Override
    public String getMuleVersion() {
        return this.versionWithEeSign;
    }
}

