/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.internal.IModuleHandler;

public class ModuleHandlerCache {
    private Map<String, ExternalContributionMuleModule> modules = new ConcurrentHashMap<String, ExternalContributionMuleModule>();

    public ModuleHandlerCache(IModuleHandler<ExternalContributionMuleModule> initialModules) {
        initialModules.getModules().forEach(module -> this.modules.put(module.getId(), (ExternalContributionMuleModule)module));
    }

    public ModuleHandlerCache() {
    }

    public ExternalContributionMuleModule get(String key) {
        return this.modules.get(key);
    }

    public ExternalContributionMuleModule computeIfAbsent(String key, Function<String, ? extends IModuleHandler<ExternalContributionMuleModule>> mappingFunction) {
        return this.modules.computeIfAbsent(key, (? super K _key) -> {
            IModuleHandler handler = (IModuleHandler)mappingFunction.apply((String)_key);
            if (handler != null) {
                List externalModules = handler.getModules();
                if (externalModules.isEmpty()) {
                    MuleCorePlugin.logError("Unable to load module form " + _key, new IllegalStateException());
                    return null;
                }
                return (ExternalContributionMuleModule)externalModules.get(0);
            }
            return null;
        });
    }

    public void put(String key, ExternalContributionMuleModule value) {
        this.modules.put(key, value);
    }

    public Collection<ExternalContributionMuleModule> getAll() {
        return this.modules.values();
    }
}

