/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.MuleModule;
import org.mule.tooling.core.module.internal.BaseModuleManager;
import org.mule.tooling.core.module.internal.ILinkableModuleManager;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.utils.collection.ListView;

public class LinkedModuleManager
extends BaseModuleManager {
    public static final LinkedModuleManager EMPTY_MANAGER = new EmptyLinkedModuleManager();
    private Object lock = new Object();
    private ILinkableModuleManager thisManager;
    private Optional<LinkedModuleManager> parent = Optional.empty();
    private Optional<LinkedModuleManager> next = Optional.empty();
    private volatile List<MuleModule> cachedAllModules;

    public LinkedModuleManager(ILinkableModuleManager value) {
        if (value instanceof LinkedModuleManager) {
            LinkedModuleManager linkedModuleManager = (LinkedModuleManager)value;
            linkedModuleManager.setParentManager(this);
        }
        this.thisManager = value;
    }

    private void setParentManager(LinkedModuleManager parent) {
        this.parent = Optional.ofNullable(parent);
    }

    public synchronized void append(ILinkableModuleManager manager) {
        if (this.next.isPresent()) {
            this.next.get().append(manager);
        } else {
            LinkedModuleManager nextManager = new LinkedModuleManager(manager);
            nextManager.setParentManager(this);
            this.setNext(nextManager);
            this.clearCache();
        }
    }

    public void detach(ILinkableModuleManager toRemove) {
        if (this.thisManager == toRemove) {
            throw new IllegalArgumentException(this.detachErrorMessage(toRemove, "cannot detach root module manager"));
        }
        if (this.thisManager instanceof LinkedModuleManager) {
            ((LinkedModuleManager)this.thisManager).detach(toRemove);
        }
        this.next().searchAndDetach(toRemove);
    }

    protected void clearCache() {
        this.getCache().clear();
        this.cachedAllModules = null;
        this.parent().clearCache();
    }

    protected void searchAndDetach(ILinkableModuleManager toRemove) {
        if (this.thisManager == toRemove) {
            LinkedModuleManager parentManager = this.parent.orElseThrow(() -> new IllegalStateException(this.detachErrorMessage(toRemove, "cannot detach an already detached manager")));
            parentManager.clearCache();
            parentManager.setNext(this.getNextManager().orElse(null));
            this.parent = Optional.empty();
        } else {
            this.next().searchAndDetach(toRemove);
        }
    }

    public Optional<LinkedModuleManager> getNextManager() {
        return this.next;
    }

    private LinkedModuleManager next() {
        return this.next.orElse(EMPTY_MANAGER);
    }

    private LinkedModuleManager parent() {
        return this.parent.orElse(EMPTY_MANAGER);
    }

    private void setNext(LinkedModuleManager nextManager) {
        if (nextManager != null) {
            nextManager.setParentManager(this);
        }
        this.next = Optional.ofNullable(nextManager);
    }

    public ILinkableModuleManager getInnerManager() {
        return this.thisManager;
    }

    @Override
    public String getMuleVersion() {
        return this.thisManager.getMuleVersion();
    }

    public Optional<ILinkableModuleManager> getManagerContaining(MuleExtension extension) {
        if (this.thisManager.containsExtension(extension)) {
            if (this.thisManager instanceof LinkedModuleManager) {
                return ((LinkedModuleManager)this.thisManager).getManagerContaining(extension);
            }
            return Optional.of(this.thisManager);
        }
        return this.next().getManagerContaining(extension);
    }

    @Override
    public boolean containsExtension(MuleExtension extension) {
        return this.thisManager.containsExtension(extension) || this.next().containsExtension(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MuleModule> getModules() {
        List result = this.cachedAllModules;
        if (result == null) {
            Object object = this.lock;
            synchronized (object) {
                result = this.cachedAllModules;
                if (result == null) {
                    result = this.cachedAllModules = ListView.of(this.getCoreModules(), this.getExternalModules());
                }
            }
        }
        return result;
    }

    @Override
    public List<MuleModule> getCoreModules() {
        return ListView.of(this.thisManager.getCoreModules(), this.next().getCoreModules());
    }

    @Override
    public List<ExternalContributionMuleModule> getExternalModules() {
        return ListView.of(this.thisManager.getExternalModules(), this.next().getExternalModules());
    }

    public String toString() {
        return "LinkedModuleManager [thisManager=" + String.valueOf(this.thisManager) + ", next=" + String.valueOf(this.next) + "]";
    }

    private String detachErrorMessage(ILinkableModuleManager toRemove, String message) {
        return message + ", thisManager= " + String.valueOf(this.thisManager) + ", toRemove= " + String.valueOf(toRemove);
    }

    private static class EmptyLinkedModuleManager
    extends LinkedModuleManager {
        public EmptyLinkedModuleManager() {
            super(null);
        }

        @Override
        public void append(ILinkableModuleManager manager) {
            throw new IllegalStateException("The empty manager cannot be part of a linked module manager");
        }

        @Override
        protected void searchAndDetach(ILinkableModuleManager toRemove) {
        }

        @Override
        protected void clearCache() {
        }

        @Override
        public Optional<LinkedModuleManager> getNextManager() {
            return Optional.empty();
        }

        @Override
        public void detach(ILinkableModuleManager toRemove) {
        }

        @Override
        public List<MuleModule> getModules() {
            return Collections.emptyList();
        }

        @Override
        public List<MuleModule> getCoreModules() {
            return Collections.emptyList();
        }

        @Override
        public List<ExternalContributionMuleModule> getExternalModules() {
            return Collections.emptyList();
        }

        @Override
        public boolean containsExtension(MuleExtension extension) {
            return false;
        }

        @Override
        public Optional<ILinkableModuleManager> getManagerContaining(MuleExtension extension) {
            return Optional.empty();
        }

        @Override
        public String toString() {
            return "EmptyLinkedModuleManager []";
        }
    }
}

