/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.module.ModuleInitializationException;
import org.mule.tooling.core.module.MuleModule;
import org.mule.tooling.core.module.internal.GroupModuleHandler;
import org.mule.tooling.core.module.internal.SingleModuleHandler;

public class CompositeModuleHandler
extends GroupModuleHandler<MuleModule> {
    public static final String CORE_CONTRIBUTION_ID = "contribution";

    public CompositeModuleHandler(String uniqueIdentifier, List<IConfigurationElement> configurationElements) {
        super(uniqueIdentifier);
        this.init(configurationElements);
    }

    protected void init(List<IConfigurationElement> configurationElements) {
        for (IConfigurationElement element : configurationElements) {
            String contributionType = element.getName();
            if (!contributionType.equals(CORE_CONTRIBUTION_ID)) continue;
            String id = element.getAttribute("id");
            if (!StringUtils.isEmpty((String)id)) {
                try {
                    SingleModuleHandler singleModuleHandler = new SingleModuleHandler(element, id);
                    this.addHandler(singleModuleHandler);
                }
                catch (ModuleInitializationException e) {
                    MuleCorePlugin.logError("Unexpected error loading module", e);
                }
                continue;
            }
            MuleCorePlugin.logWarning("Cannot create single module handler, it must have an id defined.");
        }
    }

    public String toString() {
        return "CompositeModuleHandler [handlers=" + String.valueOf(this.getHandlers()) + ", uniqueIdentifier=" + this.getUniqueIdentifier() + "]";
    }
}

