/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.module.MuleModule;

public class CategoryModuleHandler {
    List<MuleModule> muleCategories = new ArrayList<MuleModule>();
    private static final String CATEGORY_ELEMENT = "module";

    public CategoryModuleHandler(List<IConfigurationElement> configurationElements) {
        this.init(configurationElements);
    }

    public void init(List<IConfigurationElement> configurationElements) {
        for (IConfigurationElement element : configurationElements) {
            String type = element.getName();
            if (!CATEGORY_ELEMENT.equals(type)) continue;
            this.doInit(element);
        }
    }

    private void doInit(IConfigurationElement element) {
        MuleModule muleModule = new MuleModule(element.getAttribute("id"));
        try {
            muleModule.initialize(element);
            this.addModule(muleModule);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Could not initialize categories", e);
        }
    }

    private void addModule(MuleModule muleModule) {
        this.muleCategories.add(muleModule);
    }

    public List<MuleModule> getModules() {
        return this.muleCategories;
    }
}

