/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.builder.messageflow.ICanMatchElement;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.module.DefinitionNotFoundException;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.module.MuleModule;
import org.mule.tooling.core.module.QNameMap;
import org.mule.tooling.core.module.internal.ILinkableModuleManager;
import org.mule.tooling.core.module.internal.MuleModuleManagerCache;
import org.mule.tooling.editor.model.element.Stereotype;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitorAdapter;
import org.mule.tooling.model.module.CategoryDefinition;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.IKnowsVersionRange;
import org.mule.tooling.model.module.MuleConfigurationNodeDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;
import org.mule.tooling.model.module.SplitterDefinition;
import org.mule.tooling.model.module.filter.INodeDefinitionResolver;
import org.mule.tooling.model.module.filter.ModuleManagerNodeDefinitionResolver;
import org.mule.tooling.model.module.filter.StereotypeFilter;

public abstract class BaseModuleManager
implements IMuleModuleManager,
ILinkableModuleManager {
    private static final NodeDefinitionComparator NODE_DEFINITION_COMPARATOR = new NodeDefinitionComparator();
    private static final String NULL_VERSION = "null-version";
    private final Object lock = new Object();
    private IMuleModuleManager dependenciesManager;
    private MuleModuleManagerCache cache = new MuleModuleManagerCache();

    public void setDependenciesManager(IMuleModuleManager dependenciesManager) {
        this.dependenciesManager = dependenciesManager;
    }

    protected MuleModuleManagerCache getCache() {
        return this.cache;
    }

    @Override
    public List<CategoryDefinition> getCategories() {
        ArrayList<CategoryDefinition> results = new ArrayList<CategoryDefinition>();
        for (MuleModule module : this.getModules()) {
            results.addAll(module.getCategories());
        }
        Collections.sort(results);
        return results;
    }

    @Override
    public List<CategoryDefinition> getGlobalCategories(String version) {
        HashSet<CategoryDefinition> results = new HashSet<CategoryDefinition>();
        List<MuleModule> _modules = this.getModules();
        for (MuleModule module : _modules) {
            results.addAll(module.getGlobalCategories());
        }
        ArrayList<CategoryDefinition> categories = new ArrayList<CategoryDefinition>(results);
        Collections.sort(categories);
        return categories;
    }

    @Override
    public List<NodeDefinition> getDefinitions(String version) {
        String versionToCheck = this.getVersionToCheck(version);
        return this.getCache().getDefinitions(versionToCheck, () -> {
            ArrayList sortedNodeDefinitions = new ArrayList();
            List<MuleModule> modulesForVersion = this.getModules();
            for (MuleModule module : modulesForVersion) {
                Collection<NodeDefinition> definitions = module.getDefinitions();
                this.forEachSupportedDefinition(definitions, versionToCheck, sortedNodeDefinitions::add);
            }
            List<NodeDefinition> resultNodeDefinitions = this.removeEEifNeeded(versionToCheck, sortedNodeDefinitions);
            this.sortDefinitions(resultNodeDefinitions);
            return resultNodeDefinitions;
        });
    }

    private String getVersionToCheck(String version) {
        return version != null ? version : NULL_VERSION;
    }

    private void forEachSupportedDefinition(Collection<NodeDefinition> definitions, String versionToCheck, Consumer<NodeDefinition> function) {
        for (NodeDefinition definition : definitions) {
            IKnowsVersionRange service;
            if (!NULL_VERSION.equals(versionToCheck) && (service = definition.getService(IKnowsVersionRange.class)) != null && !service.supported(versionToCheck)) continue;
            function.accept(definition);
        }
    }

    private void sortDefinitions(List<? extends NodeDefinition> sortedNodeDefinitions) {
        Collections.sort(sortedNodeDefinitions, NODE_DEFINITION_COMPARATOR);
    }

    protected List<NodeDefinition> removeEEifNeeded(String version, List<? extends NodeDefinition> nodes) {
        if (version != null && version.contains(";")) {
            ArrayList<NodeDefinition> result = new ArrayList<NodeDefinition>(nodes.size());
            ArrayList<NodeDefinition> ceNodes = new ArrayList<NodeDefinition>(nodes.size());
            HashMap<String, NodeDefinition> eeNodes = new HashMap<String, NodeDefinition>();
            for (NodeDefinition node : nodes) {
                String nodeId = node.getId();
                if (nodeId.contains("/schema/mule/ee")) {
                    eeNodes.put(nodeId.replace("/schema/mule/ee", "/schema/mule"), node);
                    continue;
                }
                ceNodes.add(node);
            }
            for (NodeDefinition ceNode : ceNodes) {
                NodeDefinition replacementNode = (NodeDefinition)eeNodes.remove(ceNode.getId());
                result.add(replacementNode == null ? ceNode : replacementNode);
            }
            result.addAll(eeNodes.values());
            return result;
        }
        return nodes;
    }

    @Override
    public List<GlobalDefinition> getGlobals(String version) {
        String versionToCheck = version == null ? this.getMuleVersion() : version;
        return this.getCache().getGlobalDefinitions(versionToCheck, () -> {
            List<Object> results = new ArrayList();
            List<MuleModule> modulesForVersion = this.getModules();
            for (MuleModule module : modulesForVersion) {
                Collection<GlobalDefinition> globalDefinitions = module.getGlobalDefinitions();
                for (GlobalDefinition globalDefinition : globalDefinitions) {
                    IKnowsVersionRange service;
                    if (versionToCheck != null && (service = globalDefinition.getService(IKnowsVersionRange.class)) != null && !service.supported(versionToCheck)) continue;
                    results.add(globalDefinition);
                }
            }
            results = this.removeEEifNeeded(versionToCheck, results);
            results = this.removeDuplicateDefinitionsByServerType(versionToCheck, results);
            this.sortDefinitions(results);
            return results;
        });
    }

    private List<GlobalDefinition> removeDuplicateDefinitionsByServerType(String versionToCheck, List<GlobalDefinition> results) {
        ArrayList<GlobalDefinition> filteredResults = new ArrayList<GlobalDefinition>();
        boolean isEEServer = versionToCheck.endsWith(";");
        HashMap globalDefs = new HashMap();
        for (GlobalDefinition definition : results) {
            List defsResult = (List)globalDefs.get(definition.getId());
            if (defsResult == null) {
                ArrayList<GlobalDefinition> repeatedDefs = new ArrayList<GlobalDefinition>();
                repeatedDefs.add(definition);
                globalDefs.put(definition.getId(), repeatedDefs);
                continue;
            }
            defsResult.add(definition);
        }
        for (List defs : globalDefs.values()) {
            if (defs.size() == 1) {
                filteredResults.addAll(defs);
                continue;
            }
            for (GlobalDefinition repeated : defs) {
                IKnowsVersionRange definitionMuleServerQualifier = repeated.getService(IKnowsVersionRange.class);
                if ((!isEEServer || !definitionMuleServerQualifier.isEE()) && (isEEServer || definitionMuleServerQualifier.isEE())) continue;
                filteredResults.add(repeated);
            }
        }
        return filteredResults;
    }

    @Override
    public QNameMap<ArrayList<NodeDefinition>> getQNameMappings(String version) {
        String versionToCheck = this.getVersionToCheck(version);
        Map<QName, ArrayList<NodeDefinition>> results = this.getCache().getOverrides(versionToCheck, () -> this.doGetQnameMappings(version));
        return QNameMap.wrap(results);
    }

    @Override
    public NodeDefinition getDefinitionForElement(IElementWrapper element, String runtimeVersion) {
        ArrayList<NodeDefinition> possibleDefinitions = this.getQNameMappings(runtimeVersion).get(element.getQName());
        if (possibleDefinitions == null || possibleDefinitions.isEmpty()) {
            return null;
        }
        NodeDefinition bestCandidate = possibleDefinitions.get(0);
        int bestCandiateMatches = -1;
        for (NodeDefinition nodeDefinition : possibleDefinitions) {
            int matches;
            ICanMatchElement matcherService = nodeDefinition.getService(ICanMatchElement.class);
            if (matcherService == null || (matches = matcherService.matches(element)) <= bestCandiateMatches && bestCandiateMatches != -1) continue;
            bestCandidate = nodeDefinition;
            IKnowsVersionRange vv = bestCandidate.getService(IKnowsVersionRange.class);
            if (vv != null && !vv.supported(runtimeVersion)) {
                return null;
            }
            bestCandiateMatches = matches;
        }
        IKnowsVersionRange vv = bestCandidate.getService(IKnowsVersionRange.class);
        if (vv != null && !vv.supported(runtimeVersion)) {
            return null;
        }
        return bestCandidate;
    }

    private Map<QName, ArrayList<NodeDefinition>> doGetQnameMappings(String version) {
        final LinkedHashMap<QName, ArrayList<NodeDefinition>> results = new LinkedHashMap<QName, ArrayList<NodeDefinition>>();
        List<NodeDefinition> defs = this.getDefinitions(version);
        for (final NodeDefinition def : defs) {
            def.accept(new NodeDefinitionVisitorAdapter(){

                @Override
                public void visitPatternDefinition(PatternDefinition patternDefinition) {
                    for (QName element : patternDefinition.getMuleElements()) {
                        BaseModuleManager.this.registerQName(results, def, element);
                    }
                }

                @Override
                public void visitSplitterDefinition(SplitterDefinition splitterDefinition) {
                    for (QName element : splitterDefinition.getMuleElements()) {
                        BaseModuleManager.this.registerQName(results, def, element);
                    }
                }

                @Override
                public void visitNestedDefinition(NestedDefinition nestedDefinition) {
                }

                @Override
                public void visitEndpointDefinition(EndpointDefinition endpointDefinition) {
                    if (endpointDefinition.isAbstract()) {
                        if (!results.containsKey(endpointDefinition.getInboundMuleElement())) {
                            BaseModuleManager.this.registerQName(results, def, endpointDefinition.getInboundMuleElement());
                        }
                        if (!results.containsKey(endpointDefinition.getOutboundMuleElement())) {
                            BaseModuleManager.this.registerQName(results, def, endpointDefinition.getOutboundMuleElement());
                        }
                        return;
                    }
                    BaseModuleManager.this.registerQName(results, def, endpointDefinition.getOutboundMuleElement());
                    BaseModuleManager.this.registerQName(results, def, endpointDefinition.getInboundMuleElement());
                }

                @Override
                public void visitContainerDefinition(ContainerDefinition containerDefinition) {
                    BaseModuleManager.this.registerQName(results, def, containerDefinition.getMuleElement());
                }
            });
        }
        return results;
    }

    private void registerQName(Map<QName, ArrayList<NodeDefinition>> results, NodeDefinition rd, QName inboundMuleElement) {
        ArrayList arrayList = results.computeIfAbsent(inboundMuleElement, x -> new ArrayList());
        if (!arrayList.contains(rd)) {
            arrayList.add(rd);
        }
    }

    @Override
    public QNameMap<GlobalDefinition> getGlobalQNameMappings(String version) {
        HashMap<QName, GlobalDefinition> results = new HashMap<QName, GlobalDefinition>();
        List<GlobalDefinition> globals = this.getGlobals(version);
        for (GlobalDefinition global : globals) {
            for (QName qName : global.getMuleElements()) {
                results.put(qName, global);
            }
        }
        return QNameMap.wrap(results);
    }

    @Override
    public NodeDefinition getDefinition(String type) {
        return this.getDefinition(type, this.getMuleVersion(), true);
    }

    @Override
    public NodeDefinition getDefinition(String type, String muleVersion) {
        return this.getDefinition(type, muleVersion, true);
    }

    @Override
    public NodeDefinition getDefinition(String type, boolean failIfNotFound) {
        return this.getDefinition(type, this.getMuleVersion(), failIfNotFound);
    }

    @Override
    public NodeDefinition getDefinition(String type, String version, boolean failIfNotFound) {
        if ("http://www.mulesoft.org/schema/mule/core/mule".equals(type)) {
            return MuleConfigurationNodeDefinition.get();
        }
        List<NodeDefinition> definitions = this.getDefinitions(version);
        for (NodeDefinition definition : definitions) {
            if (!definition.getId().equals(type)) continue;
            return definition;
        }
        if (failIfNotFound) {
            throw new DefinitionNotFoundException(type);
        }
        return null;
    }

    @Override
    public boolean hasDefinition(String type) {
        List<NodeDefinition> definitions = this.getDefinitions(this.getMuleVersion());
        for (NodeDefinition definition : definitions) {
            if (!definition.getId().equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<NodeDefinition> getDefinitionsForCategory(String categoryId, String version) {
        ArrayList results = new ArrayList();
        for (MuleModule module : this.getModules()) {
            List<NodeDefinition> modResults = module.getNodesForCategoryId(categoryId);
            if (modResults == null) continue;
            this.forEachSupportedDefinition(modResults, version, results::add);
        }
        List<NodeDefinition> finalResults = this.removeEEifNeeded(version, results);
        this.sortDefinitions(finalResults);
        return finalResults;
    }

    @Override
    public GlobalDefinition getGlobalDefinition(String type) {
        for (GlobalDefinition definition : this.getGlobals(null)) {
            if (!definition.getId().equals(type)) continue;
            return definition;
        }
        return null;
    }

    @Override
    public GlobalDefinition getGlobalDefinition(String type, String version) {
        List<GlobalDefinition> globals = this.getGlobals(version);
        for (GlobalDefinition definition : globals) {
            if (!definition.getId().equals(type)) continue;
            return definition;
        }
        return null;
    }

    @Override
    public List<GlobalDefinition> getGlobalDefinitionsForPaletteCategory(String paletteCategoryId, String version) {
        ArrayList<GlobalDefinition> results = new ArrayList();
        for (MuleModule module : this.getModules()) {
            List<GlobalDefinition> modResults = module.getGlobalDefinitionsForPaletteCategoryId(paletteCategoryId);
            if (modResults == null) continue;
            results.addAll(modResults);
        }
        results = this.removeEEifNeeded(version, results);
        this.sortDefinitions(results);
        return results;
    }

    @Override
    public Collection<NestedDefinition> getNested() {
        this.ensureNestedCacheInitialized();
        return this.getCache().getSortedNestedDefinitions();
    }

    private void initNestedModules() {
        HashMap<String, NestedDefinition> _nestedModulesIndex = new HashMap<String, NestedDefinition>();
        for (MuleModule module : this.getModules()) {
            Collection<NestedDefinition> nested = module.getNested();
            for (NestedDefinition nestedDefinition : nested) {
                _nestedModulesIndex.put(nestedDefinition.getId(), nestedDefinition);
            }
        }
        this.getCache().setNestedDefinitionsCache(_nestedModulesIndex);
    }

    @Override
    public NestedDefinition getNestedDefinition(String id) {
        this.ensureNestedCacheInitialized();
        if (this.getCache().containsNestedDefinition(id)) {
            return this.getCache().getNestedDefinition(id);
        }
        if (this.hasDependenciesManager()) {
            return this.dependenciesManager.getNestedDefinition(id);
        }
        return null;
    }

    @Override
    public NestedDefinition getNestedDefinition(QName name) {
        Collection<NestedDefinition> nested = this.getNested();
        Optional<NestedDefinition> nestedDefinition = nested.stream().filter(def -> def.matches(name)).findFirst();
        if (nestedDefinition.isPresent()) {
            return nestedDefinition.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureNestedCacheInitialized() {
        if (this.getCache().isNestedDefinitionsCacheEmpty()) {
            Object object = this.lock;
            synchronized (object) {
                if (this.getCache().isNestedDefinitionsCacheEmpty()) {
                    this.initNestedModules();
                }
            }
        }
    }

    @Override
    public List<GlobalDefinition> getGlobalDefinitionsFor(String id) {
        return this.getCache().getGlobalSubtypes(id, () -> {
            List globalDefs = this.getGlobalSubtypes(id).stream().filter(global -> !global.isAbstract()).collect(Collectors.toList());
            GlobalDefinition selfDef = this.getGlobalDefinition(id);
            if (selfDef != null && !selfDef.isAbstract()) {
                globalDefs.add(selfDef);
            }
            this.sortDefinitions(globalDefs);
            return globalDefs;
        });
    }

    private Set<GlobalDefinition> getGlobalSubtypes(String id) {
        HashSet result = Sets.newHashSet();
        this.getModules().forEach(module -> {
            Set<GlobalDefinition> subtypes = module.getGlobalSubtypes(id);
            result.addAll(subtypes);
            subtypes.forEach(subtype -> result.addAll(this.getGlobalSubtypes(subtype.getId())));
        });
        return result;
    }

    @Override
    public List<NestedDefinition> getNestedDefinitionFor(String id) {
        return this.getCache().getAllowedChildrenOfDefinition(id, () -> {
            List nestedDefinitionsForElement = this.getSubtypes(id).stream().filter(nested -> !nested.isAbstract()).collect(Collectors.toList());
            NestedDefinition selfDefinition = this.getNestedDefinition(id);
            if (selfDefinition != null && !selfDefinition.isAbstract() && !selfDefinition.isIgnoreInHierarchy()) {
                nestedDefinitionsForElement.add(selfDefinition);
            }
            this.sortDefinitions(nestedDefinitionsForElement);
            return nestedDefinitionsForElement;
        });
    }

    @Override
    public List<NestedDefinition> getNestedDefinitionFor(Stereotype stereotype) {
        INodeDefinitionResolver nodeDefinitionResolver = ModuleManagerNodeDefinitionResolver.get();
        return this.getCache().getAllowedChildrenOfDefinition(stereotype, () -> {
            StereotypeFilter filter = new StereotypeFilter(Arrays.asList(stereotype));
            List nestedDefinitionsForElement = this.getNested().stream().filter(x -> filter.accepts((NodeDefinition)x, nodeDefinitionResolver)).collect(Collectors.toList());
            this.sortDefinitions(nestedDefinitionsForElement);
            return nestedDefinitionsForElement;
        });
    }

    private Set<NestedDefinition> getSubtypes(String id) {
        HashSet result = Sets.newHashSet();
        this.getModules().forEach(module -> {
            Set<NestedDefinition> subtypes = module.getSubtypes(id);
            result.addAll(subtypes);
            subtypes.forEach(subtype -> result.addAll(this.getSubtypes(subtype.getId())));
        });
        return result;
    }

    @Override
    public List<NodeDefinition> getExtendedGlobals(GlobalDefinition definition) {
        ArrayList<NodeDefinition> result = new ArrayList<NodeDefinition>();
        String ids = definition.getExtendsDefinition();
        String[] stringArray = ids.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!StringUtils.isEmpty((String)id)) {
                GlobalDefinition global = this.getGlobalDefinition(id);
                if (global != null) {
                    result.add(global);
                } else if (this.hasDependenciesManager() && (global = this.dependenciesManager.getGlobalDefinition(id)) != null) {
                    result.add(global);
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    public List<NodeDefinition> getExtendedDefinitions(NodeDefinition definition) {
        ArrayList<NodeDefinition> result = new ArrayList<NodeDefinition>();
        String ids = definition.getExtendsDefinition();
        if (ids != null) {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (!StringUtils.isEmpty((String)id)) {
                    if (this.hasDefinition(id)) {
                        result.add(this.getDefinition(id));
                    } else if (this.hasDependenciesManager() && this.dependenciesManager.hasDefinition(id)) {
                        result.add(this.dependenciesManager.getDefinition(id));
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public List<NestedDefinition> getExtendedNestedElements(NestedDefinition definition) {
        ArrayList<NestedDefinition> result = new ArrayList<NestedDefinition>();
        String ids = definition.getExtendsDefinition();
        String[] stringArray = ids.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!StringUtils.isEmpty((String)id)) {
                NestedDefinition nestedElement = this.getNestedDefinition(id);
                if (nestedElement != null) {
                    result.add(nestedElement);
                } else if (this.hasDependenciesManager() && (nestedElement = this.dependenciesManager.getNestedDefinition(id)) != null) {
                    result.add(nestedElement);
                }
            }
            ++n2;
        }
        return result;
    }

    private boolean hasDependenciesManager() {
        return this.dependenciesManager != null;
    }

    @Override
    public Optional<CategoryDefinition> getCategory(String categoryId) {
        return this.getCategories().stream().filter(input -> input.getId().equals(categoryId)).findFirst();
    }

    public Optional<CategoryDefinition> getCategoryByName(String categoryName) {
        return this.getCategories().stream().filter(input -> input.getName().equals(categoryName)).findFirst();
    }

    private static final class NodeDefinitionComparator
    implements Comparator<NodeDefinition> {
        private NodeDefinitionComparator() {
        }

        @Override
        public int compare(NodeDefinition o1, NodeDefinition o2) {
            int nameCompare;
            String name1 = o1.getName();
            String name2 = o2.getName();
            int n = name1 == null ? (name2 == null ? 0 : -1) : (nameCompare = name1.compareTo(name2));
            if (nameCompare == 0) {
                return o1.getId().compareTo(o2.getId());
            }
            return nameCompare;
        }
    }
}

