/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.internal;

import java.util.Optional;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.module.ImageRetriever;
import org.mule.tooling.core.module.internal.BaseModuleManager;
import org.mule.tooling.model.module.CategoryDefinition;
import org.mule.tooling.model.module.NodeDefinition;

public abstract class AbstractImageRetriever<T>
implements ImageRetriever<T> {
    @Override
    public T getImage(IMuleModuleManager moduleManager, String id) {
        Optional<T> result = Optional.empty();
        BaseModuleManager manager = (BaseModuleManager)moduleManager;
        result = this.getOnlyInsideImage(manager, id);
        if (result.isPresent()) {
            return result.get();
        }
        if (manager.hasDefinition(id)) {
            NodeDefinition definition = manager.getDefinition(id);
            Optional<CategoryDefinition> category = manager.getCategory(definition.getCategoryId());
            result = this.getCategoryDefaultImage(manager, category);
            return result.orElse(this.getUnknownImage(manager));
        }
        return this.getUnknownImage(manager);
    }

    public Optional<T> getCategoryDefaultImage(BaseModuleManager manager, Optional<CategoryDefinition> category) {
        if (!category.isPresent()) {
            return Optional.empty();
        }
        return this.getOnlyInsideImage(manager, category.get().getId() + ".default");
    }

    public abstract T getUnknownImage(BaseModuleManager var1);

    public abstract Optional<T> getOnlyInsideImage(BaseModuleManager var1, String var2);
}

