/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.contribution;

import java.util.Set;
import java.util.stream.Collectors;
import org.mule.tooling.core.module.contribution.ExternalLibraryModel;
import org.mule.tooling.core.module.contribution.ExternalLibraryType;

public class ExternalLibraryMapper {
    private ExternalLibraryMapper() {
    }

    public static Set<ExternalLibraryModel> toExternalLibraries(Set<org.mule.tooling.client.api.extension.model.ExternalLibraryModel> externalLibraryModels) {
        return externalLibraryModels.stream().map(ExternalLibraryMapper::toExternalLibrary).collect(Collectors.toSet());
    }

    public static ExternalLibraryModel toExternalLibrary(org.mule.tooling.client.api.extension.model.ExternalLibraryModel model) {
        ExternalLibraryModel lib = new ExternalLibraryModel();
        lib.setName(model.getName());
        lib.setDescription(model.getDescription());
        lib.setOptional(model.isOptional());
        lib.setRegexMatcher(model.getRegexMatcher());
        lib.setRequiredClassName(model.getRequiredClassName());
        lib.setSuggestedCoordinates(model.getSuggestedCoordinates());
        lib.setType(ExternalLibraryMapper.getTypeFrom(model.getType()));
        return lib;
    }

    private static ExternalLibraryType getTypeFrom(org.mule.tooling.client.api.extension.model.ExternalLibraryType externalLibraryType) {
        ExternalLibraryType type = ExternalLibraryType.UNKNOWN;
        if (externalLibraryType.isDependency()) {
            type = ExternalLibraryType.DEPENDENCY;
        } else if (externalLibraryType.isJar()) {
            type = ExternalLibraryType.JAR;
        } else if (externalLibraryType.isNativeLibrary()) {
            type = ExternalLibraryType.NATIVE_LIBRARY;
        }
        return type;
    }
}

