/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.IModuleContributionManager;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.module.MuleModule;
import org.mule.tooling.core.module.internal.MuleModuleManager;
import org.mule.tooling.core.module.internal.SingleExtensionModuleManager;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.model.project.MuleExtension;

public class MuleModuleManagerFactory {
    public static IMuleModuleManager createModuleManager(String versionWithEESign) {
        IModuleContributionManager contributionManager = MuleCorePlugin.getModuleContributionManager();
        return MuleModuleManagerFactory.createDefaultManager(contributionManager, versionWithEESign);
    }

    private static IMuleModuleManager createDefaultManager(IModuleContributionManager contributionManager, String versionWithEESign) {
        List<MuleModule> coreModules = contributionManager.getModules("default");
        return MuleModuleManagerFactory.createMuleModuleManager(coreModules, versionWithEESign);
    }

    private static MuleModuleManager createMuleModuleManager(List<MuleModule> modules, String versionWithEESign) {
        IModuleContributionManager contributionManager = MuleCorePlugin.getModuleContributionManager();
        List<MuleModule> categoryModules = contributionManager.getCategoryModules();
        ArrayList<MuleModule> allModules = new ArrayList<MuleModule>();
        allModules.addAll(modules);
        allModules.addAll(categoryModules);
        return new MuleModuleManager(allModules, Collections.emptyList(), versionWithEESign);
    }

    public static SingleExtensionModuleManager createMuleModuleManager(IMuleProject muleProject, ExternalContributionMuleModule externalModule, IServerDefinition server, MuleExtension extension) {
        IModuleContributionManager contributionManager = MuleCorePlugin.getModuleContributionManager();
        List<MuleModule> categoryModules = contributionManager.getCategoryModules();
        return new SingleExtensionModuleManager(extension, externalModule, categoryModules, server.getVersionWithEESign());
    }
}

