/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Namespace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.mule.tooling.core.IconsLocator;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.module.Artifact;
import org.mule.tooling.core.module.IContributionElementHandler;
import org.mule.tooling.core.module.IModuleLoaderHandler;
import org.mule.tooling.core.module.internal.ContributionHandlerManager;
import org.mule.tooling.core.module.internal.IOverrideHandler;
import org.mule.tooling.core.module.templates.TemplateManager;
import org.mule.tooling.icons.ImagesManager;
import org.mule.tooling.images.StudioImages;
import org.mule.tooling.internal.core.module.BundleBasedArtifact;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.module.CategoryDefinition;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;
import org.mule.tooling.model.module.PropertyPageDefinition;
import org.mule.tooling.model.module.RouteDefinition;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MuleModule {
    public static final String DEFAULT_IMAGES_CATEGORY_SUFFIX = ".default";
    public static final String ICONS_CATEGORIES_DIRECTORY = "icons/categories/";
    public static final String DEFAULT_CATEGORY_ICON_SUFFIX = ".icon.default";
    public static final String DEFAULT_CATEGORY_IMAGE_SUFFIX = ".image.default";
    protected final String id;
    protected String name;
    private String description;
    protected String iconPath;
    protected Image iconImage;
    protected Artifact muleArtifact;
    protected Map<String, NodeDefinition> definitions = new HashMap<String, NodeDefinition>();
    protected Map<String, GlobalDefinition> globals = new HashMap<String, GlobalDefinition>();
    protected Map<String, NestedDefinition> nestedDefinitions = new HashMap<String, NestedDefinition>();
    protected Map<String, CategoryDefinition> categories = new HashMap<String, CategoryDefinition>();
    protected Map<String, List<NodeDefinition>> defsByCategoryId = new HashMap<String, List<NodeDefinition>>();
    protected Map<String, List<NodeDefinition>> defsByPaletteCategoryId = new HashMap<String, List<NodeDefinition>>();
    protected Map<String, CategoryDefinition> globalCategories = new HashMap<String, CategoryDefinition>();
    protected Map<String, List<GlobalDefinition>> globalsByCategoryId = new HashMap<String, List<GlobalDefinition>>();
    protected Map<String, List<GlobalDefinition>> globalsByPaletteCategoryId = new HashMap<String, List<GlobalDefinition>>();
    protected Map<String, Set<NestedDefinition>> subtypeDefinitions = new HashMap<String, Set<NestedDefinition>>();
    private Map<String, Set<GlobalDefinition>> globalSubtypeDefinitions = new HashMap<String, Set<GlobalDefinition>>();
    private ModeOperationOverrideModuleLoaderHandler handlerRef;

    public MuleModule(String id) {
        this(id, new ModeOperationOverrideModuleLoaderHandler(new NaiveOverrideHandler()));
    }

    public MuleModule(String id, ModeOperationOverrideModuleLoaderHandler handlerRef) {
        this.id = id;
        this.handlerRef = handlerRef;
        handlerRef.setModule(this);
    }

    public void initialize(IConfigurationElement configurationElement) throws CoreException {
        IConfigurationElement[] children;
        this.muleArtifact = this.getBundle(configurationElement);
        if (this.id == null) {
            throw new IllegalStateException("Bundle ID should not be null");
        }
        this.name = configurationElement.getAttribute("name");
        this.setDescription(configurationElement.getAttribute("description"));
        String iconPath = configurationElement.getAttribute("icon");
        if (iconPath != null && iconPath.length() > 0) {
            this.iconPath = iconPath;
        }
        IConfigurationElement[] iConfigurationElementArray = children = configurationElement.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String type = child.getName();
            if ("category".equals(type)) {
                this.loadCategory(child);
            } else if ("globalCategory".equals(type)) {
                this.loadGlobalCategory(child);
            } else if ("endpoint".equals(type)) {
                this.loadEndpoint(child);
            } else if ("pattern".equals(type)) {
                this.loadPattern(child);
            } else if ("global".equals(type)) {
                this.loadGlobal(child);
            }
            ++n2;
        }
    }

    protected void addNestedDefinition(NestedDefinition definition) {
        String extendsDefinition;
        this.nestedDefinitions.put(definition.getId(), definition);
        if (!definition.isIgnoreInHierarchy() && StringUtils.isNotBlank((String)(extendsDefinition = definition.getExtendsDefinition()))) {
            Arrays.asList(extendsDefinition.split(",")).forEach(extendDefinition -> this.subtypeDefinitions.computeIfAbsent((String)extendDefinition, k -> Sets.newHashSet()).add(definition));
        }
    }

    protected QName createQName(String namespace, String localName) {
        if (namespace == null || localName == null) {
            return null;
        }
        return new QName(namespace, localName);
    }

    protected void loadCategory(IConfigurationElement element) throws CoreException {
        CategoryDefinition category = new CategoryDefinition();
        category.setId(element.getAttribute("id"));
        category.setName(element.getAttribute("name"));
        String paletteWtStr = element.getAttribute("paletteWeight");
        try {
            category.setPaletteWeight(Integer.parseInt(paletteWtStr));
        }
        catch (NumberFormatException numberFormatException) {
            category.setPaletteWeight(0);
        }
        String expandStr = element.getAttribute("expandByDefault");
        category.setExpandByDefault("true".equalsIgnoreCase(expandStr));
        this.categories.put(category.getId(), category);
    }

    protected void loadGlobalCategory(IConfigurationElement element) throws CoreException {
        CategoryDefinition category = new CategoryDefinition();
        category.setId(element.getAttribute("id"));
        category.setName(element.getAttribute("name"));
        category.setParentCategory(element.getAttribute("parentCategory"));
        this.globalCategories.put(category.getId(), category);
    }

    protected void addDefinition(NodeDefinition definition) {
        String id = definition.getId();
        if (this.definitions.containsKey(id)) {
            System.out.println("Duplicate entry detected! " + id + " - Please, remove it!");
            return;
        }
        this.definitions.put(id, definition);
        if (!definition.isAbstract()) {
            List<NodeDefinition> defs = this.defsByCategoryId.get(definition.getCategoryId());
            if (defs == null) {
                defs = new ArrayList<NodeDefinition>();
                this.defsByCategoryId.put(definition.getCategoryId(), defs);
            }
            defs.add(definition);
            defs = this.defsByPaletteCategoryId.get(definition.getPaletteCategoryId());
            if (defs == null) {
                defs = new ArrayList<NodeDefinition>();
                this.defsByPaletteCategoryId.put(definition.getPaletteCategoryId(), defs);
            }
            defs.add(definition);
        }
    }

    protected void addGlobalDefinition(GlobalDefinition global) {
        String id = global.getId();
        if (this.globals.containsKey(id)) {
            System.out.println("Duplicate global entry detected! " + id + " - Please, remove it!");
            return;
        }
        this.globals.put(id, global);
        String extendsDefinition = global.getExtendsDefinition();
        if (StringUtils.isNotBlank((String)extendsDefinition)) {
            Arrays.asList(extendsDefinition.split(",")).forEach(extendDefinition -> this.globalSubtypeDefinitions.computeIfAbsent((String)extendDefinition, k -> Sets.newHashSet()).add(global));
        }
        if (!global.isAbstract()) {
            String categoryId = global.getCategoryId();
            this.processGlobalCategory(global, categoryId);
        }
    }

    private void processGlobalCategory(GlobalDefinition global, String categoryId) {
        String parentCategory;
        List<GlobalDefinition> existing = this.globalsByCategoryId.get(categoryId);
        if (existing == null) {
            existing = new ArrayList<GlobalDefinition>();
            this.globalsByCategoryId.put(global.getCategoryId(), existing);
        }
        existing.add(global);
        String paletteCategoryId = global.getPaletteCategoryId();
        existing = this.globalsByPaletteCategoryId.get(paletteCategoryId);
        if (existing == null) {
            existing = new ArrayList<GlobalDefinition>();
            this.globalsByPaletteCategoryId.put(paletteCategoryId, existing);
        }
        existing.add(global);
        CategoryDefinition categoryDefinition = this.globalCategories.get(categoryId);
        if (categoryDefinition != null && (parentCategory = categoryDefinition.getParentCategory()) != null) {
            this.processGlobalCategory(global, categoryId);
        }
    }

    protected void loadEndpoint(IConfigurationElement element) throws CoreException {
        EndpointDefinition endpoint = new EndpointDefinition();
        this.loadCommonProperties(endpoint, element);
        String namespace = element.getAttribute("muleNamespace");
        String inboundName = element.getAttribute("inboundLocalName");
        String outboundName = element.getAttribute("outboundLocalName");
        endpoint.setInboundMuleElement(this.createQName(namespace, inboundName));
        endpoint.setOutboundMuleElement(this.createQName(namespace, outboundName));
        endpoint.setSupportsInbound("true".equals(element.getAttribute("supportsInbound")));
        endpoint.setSupportsOutbound("true".equals(element.getAttribute("supportsOutbound")));
        endpoint.setDefaultMep(element.getAttribute("defaultMep"));
        this.addDefinition(endpoint);
    }

    protected void loadPattern(IConfigurationElement element) throws CoreException {
        String[] localNames;
        PatternDefinition pattern = new PatternDefinition();
        this.loadCommonProperties(pattern, element);
        String namespace = element.getAttribute("muleNamespace");
        String localNamesDelimited = element.getAttribute("muleLocalName");
        String[] stringArray = localNames = localNamesDelimited.split(",");
        int n = localNames.length;
        int n2 = 0;
        while (n2 < n) {
            String localName = stringArray[n2];
            pattern.getMuleElements().add(this.createQName(namespace, localName));
            ++n2;
        }
        pattern.setCausesSplit("true".equals(element.getAttribute("causesSplit")));
        pattern.setCausesJoin("true".equals(element.getAttribute("causesJoin")));
        pattern.setProcessesResponse("true".equals(element.getAttribute("processesResponse")));
        pattern.setContributesToPath("true".equals(element.getAttribute("contributesToPath")));
        pattern.setPathExpression(element.getAttribute("pathExpression"));
        this.addDefinition(pattern);
    }

    protected void loadGlobal(IConfigurationElement element) throws CoreException {
        String[] localNames;
        GlobalDefinition global = new GlobalDefinition();
        this.loadCommonProperties(global, element);
        String namespace = element.getAttribute("muleNamespace");
        String localNamesDelimited = element.getAttribute("muleLocalName");
        String[] stringArray = localNames = localNamesDelimited.split(",");
        int n = localNames.length;
        int n2 = 0;
        while (n2 < n) {
            String localName = stringArray[n2];
            global.getMuleElements().add(this.createQName(namespace, localName.trim()));
            ++n2;
        }
        this.addGlobalDefinition(global);
    }

    protected void loadCommonProperties(NodeDefinition definition, IConfigurationElement element) throws CoreException {
        definition.setBundleSymbolicName(this.muleArtifact.getId());
        String plugin = element.getContributor().getName();
        definition.setId(element.getAttribute("id"));
        if (definition.getId() == null) {
            throw new CoreException(MuleCorePlugin.createStatus(4, "No id specified for node.", null));
        }
        definition.setName(element.getAttribute("name"));
        definition.setDescription(element.getAttribute("description"));
        definition.setCategoryId(element.getAttribute("category"));
        if (definition.getCategoryId() == null) {
            throw new CoreException(MuleCorePlugin.createStatus(4, "No category id specified for " + definition.getId(), null));
        }
        definition.setPaletteCategoryId(element.getAttribute("paletteCategory"));
        String iconPath = element.getAttribute("icon");
        String imagePath = element.getAttribute("image");
        if (!StringUtils.isEmpty((String)iconPath)) {
            definition.setIconPath(plugin, iconPath);
        }
        if (!StringUtils.isEmpty((String)imagePath)) {
            definition.setImagePath(plugin, imagePath);
        }
        definition.setXmlGenerator(this.getXmlGenerator(element));
        definition.setModelGenerator(this.getModelGenerator(element));
        definition.setActionDelegate(this.getActionDelegate(element));
        IConfigurationElement[] pageElements = element.getChildren("propertyPage");
        definition.setPropertyPages(this.getPropertyPages(pageElements));
        this.cacheImages(definition);
    }

    public static String createUniqueIdForImage(Artifact muleArtifact, String relatePathOfImageInsideBundle) {
        return muleArtifact.getId() + ":" + muleArtifact.getVersion() + "/" + relatePathOfImageInsideBundle;
    }

    protected List<PropertyPageDefinition> getPropertyPages(IConfigurationElement[] elements) {
        ArrayList<PropertyPageDefinition> results = new ArrayList<PropertyPageDefinition>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            results.add(this.getPropertyPage(element));
            ++n2;
        }
        return results;
    }

    protected PropertyPageDefinition getPropertyPage(IConfigurationElement element) {
        PropertyPageDefinition page = new PropertyPageDefinition();
        page.setName(element.getAttribute("name"));
        page.setDescription(element.getAttribute("description"));
        String classname = element.getAttribute("pageClass");
        page.setPageClass(MuleModule.getClassFromPlugin(element, classname));
        String direction = element.getAttribute("direction");
        if (direction != null) {
            if ("Outbound".equals(direction)) {
                page.setDirection(EndpointDirection.OUTBOUND);
            } else {
                page.setDirection(EndpointDirection.INBOUND);
            }
        }
        return page;
    }

    protected Class<?> getXmlGenerator(IConfigurationElement element) throws CoreException {
        String className = element.getAttribute("xmlGenerator");
        if (className == null) {
            throw new CoreException(MuleCorePlugin.createStatus(4, "XML generator class not specified.", null));
        }
        Class<?> clazz = MuleModule.getClassFromPlugin(element, className);
        if (clazz == null) {
            throw new CoreException(MuleCorePlugin.createStatus(4, "XML generator class could not be loaded. Class: " + className + " Bundle: " + element.getContributor().getName(), null));
        }
        return clazz;
    }

    protected Class<?> getModelGenerator(IConfigurationElement element) throws CoreException {
        String className = element.getAttribute("modelGenerator");
        if (className == null) {
            throw new CoreException(MuleCorePlugin.createStatus(4, "Model generator class not specified.", null));
        }
        Class<?> clazz = MuleModule.getClassFromPlugin(element, className);
        if (clazz == null) {
            throw new CoreException(MuleCorePlugin.createStatus(4, "Model generator class could not be loaded.", null));
        }
        return clazz;
    }

    protected Class<?> getActionDelegate(IConfigurationElement element) throws CoreException {
        String className = element.getAttribute("actionDelegate");
        if (className == null) {
            return null;
        }
        Class<?> clazz = MuleModule.getClassFromPlugin(element, className);
        if (clazz == null) {
            throw new CoreException(MuleCorePlugin.createStatus(4, "Action delegate class could not be loaded.", null));
        }
        return clazz;
    }

    public static Class<?> getClassFromPlugin(IConfigurationElement element, String classname) {
        String plugin = element.getContributor().getName();
        try {
            Bundle bundle = Platform.getBundle((String)plugin);
            Class clazz = bundle.loadClass(classname);
            return clazz;
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public void shutdown() {
        if (this.iconImage != null) {
            this.iconImage.dispose();
        }
    }

    protected Artifact getBundle(IConfigurationElement element) {
        String plugin = element.getContributor().getName();
        try {
            return new BundleBasedArtifact(Platform.getBundle((String)plugin));
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            return null;
        }
    }

    public Collection<CategoryDefinition> getCategories() {
        return this.categories.values();
    }

    public Collection<CategoryDefinition> getGlobalCategories() {
        Collection<CategoryDefinition> values = this.globalCategories.values();
        return values;
    }

    public Collection<NodeDefinition> getDefinitions() {
        return this.definitions.values();
    }

    public Collection<GlobalDefinition> getGlobalDefinitions() {
        return this.globals.values();
    }

    public List<NodeDefinition> getNodesForCategoryId(String categoryId) {
        return this.defsByCategoryId.get(categoryId);
    }

    public List<NodeDefinition> getNodesForPaletteCategoryId(String paletteCategoryId) {
        return this.defsByPaletteCategoryId.get(paletteCategoryId);
    }

    public List<GlobalDefinition> getGlobalDefinitionsForCategoryId(String categoryId) {
        return this.globalsByCategoryId.get(categoryId);
    }

    public List<GlobalDefinition> getGlobalDefinitionsForPaletteCategoryId(String paletteCategoryId) {
        return this.globalsByPaletteCategoryId.get(paletteCategoryId);
    }

    public Set<NestedDefinition> getSubtypes(String definitionId) {
        return Optional.ofNullable(this.subtypeDefinitions.get(definitionId)).orElse(Collections.emptySet());
    }

    public Set<GlobalDefinition> getGlobalSubtypes(String globalId) {
        return Optional.ofNullable(this.globalSubtypeDefinitions.get(globalId)).orElse(Collections.emptySet());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ImageDescriptor getIcon() {
        ImageDescriptor icon = IconsLocator.getDescriptor(this.iconPath);
        return icon == null ? StudioImages.PALETTE_GENERIC : icon;
    }

    public Image getIconImage() {
        if (this.iconImage == null) {
            ImageDescriptor icon = this.getIcon();
            try {
                this.iconImage = icon != null ? icon.createImage() : null;
            }
            catch (SWTException ex) {
                MuleCorePlugin.logWarning("Failed to load icon: " + this.iconPath, ex);
                this.iconImage = StudioImages.PALETTE_GENERIC.createImage();
            }
        }
        return this.iconImage;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public void initialize(Artifact muleArtifact, Document document) {
        this.muleArtifact = muleArtifact;
        document = TemplateManager.process(document);
        Element namespaceDocumentElement = document.getDocumentElement();
        String namespaceUrl = namespaceDocumentElement.getAttribute("url");
        String prefix = namespaceDocumentElement.getAttribute("prefix");
        Namespace namespace = Namespace.get((String)prefix, (String)namespaceUrl);
        NodeList childNodes = namespaceDocumentElement.getChildNodes();
        MuleModule.initElements(childNodes, muleArtifact, namespace, this.handlerRef);
    }

    public static List<? extends NodeDefinition> initElements(NodeList childNodes, Artifact muleArtifact, Namespace namespace, IModuleLoaderHandler handlerRef) {
        ArrayList initedNodeDefinitions = new ArrayList();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node item = childNodes.item(i);
            if (item.getNodeType() == 1) {
                try {
                    Element element = (Element)item;
                    IContributionElementHandler<?> contributionElementHandler = ContributionHandlerManager.instance().getContributionElementHandler(element.getNodeName());
                    if (contributionElementHandler != null) {
                        initedNodeDefinitions.add(contributionElementHandler.handleElement(namespace, element, muleArtifact, handlerRef));
                    }
                }
                catch (CoreException e) {
                    MuleCorePlugin.getLog().log(e.getStatus());
                }
            }
            ++i;
        }
        return initedNodeDefinitions;
    }

    public Collection<? extends NestedDefinition> getNestedElementsFor(String id2) {
        ArrayList<NestedDefinition> result = new ArrayList<NestedDefinition>();
        for (NestedDefinition d : this.nestedDefinitions.values()) {
            HashSet<String> allSuperTypeIds;
            if (d.isAbstract() || d.isIgnoreInHierarchy() || !(allSuperTypeIds = this.getAllSuperTypeIds(d)).contains(id2)) continue;
            result.add(d);
        }
        return result;
    }

    private HashSet<String> getAllSuperTypeIds(NestedDefinition d) {
        HashSet<String> result = new HashSet<String>();
        result.add(d.getId());
        List<NestedDefinition> parentDefinitions = MuleCorePlugin.getModuleManager().getExtendedNestedElements(d);
        for (NestedDefinition nestedDefinition : parentDefinitions) {
            result.addAll(this.getAllSuperTypeIds(nestedDefinition));
        }
        return result;
    }

    public Collection<NestedDefinition> getNested() {
        return this.nestedDefinitions.values();
    }

    public boolean isExternal() {
        return false;
    }

    public String toString() {
        return "MuleModule [id=" + this.id + "]";
    }

    public void cacheImages(NodeDefinition def) {
        ImagesManager.getInstance().register(def.getId(), IconsLocator.getImageURL(def.getIconPath()));
        ImagesManager.getInstance().register(def.getIconPath(), IconsLocator.getImageURL(def.getIconPath()));
        ImagesManager.getInstance().register(def.getImagePath(), IconsLocator.getImageURL(def.getImagePath()));
    }

    public URL getResource(IPath path) throws MalformedURLException, IOException {
        return this.muleArtifact.getResource(path);
    }

    public URL getResource(String path) throws MalformedURLException, IOException {
        return this.muleArtifact.getResource(path);
    }

    public String getVersion() {
        return this.muleArtifact.getVersion();
    }

    public File getRoot() throws MalformedURLException, IOException {
        return this.muleArtifact.getRoot();
    }

    public <T> T newInstance(String customClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.muleArtifact.newInstance(customClass);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.muleArtifact == null ? 0 : this.muleArtifact.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MuleModule other = (MuleModule)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.muleArtifact == null ? other.muleArtifact != null : !this.muleArtifact.equals(other.muleArtifact));
    }

    public static class ModeOperationOverrideModuleLoaderHandler
    implements IModuleLoaderHandler {
        private IOverrideHandler moduleHandler;
        protected MuleModule module;

        public ModeOperationOverrideModuleLoaderHandler(IOverrideHandler moduleHandler) {
            this.moduleHandler = moduleHandler;
        }

        public void setModule(MuleModule module) {
            this.module = module;
        }

        @Override
        public void addDefinition(NodeDefinition def) {
            if (def instanceof GlobalDefinition) {
                this.module.addGlobalDefinition((GlobalDefinition)def);
            } else {
                if (def instanceof NestedDefinition) {
                    NestedDefinition nd = (NestedDefinition)def;
                    this.module.addNestedDefinition(nd);
                    if (def instanceof RouteDefinition) {
                        this.module.cacheImages(def);
                    }
                    return;
                }
                this.module.addDefinition(def);
            }
            this.module.cacheImages(def);
        }

        @Override
        public void registerCategory(CategoryDefinition cdef, boolean global) {
            if (global) {
                this.module.globalCategories.put(cdef.getId(), cdef);
            } else {
                this.module.categories.put(cdef.getId(), cdef);
            }
        }

        @Override
        public void registerOverride(NodeDefinition nodeDefinition, String from, boolean global) {
            this.moduleHandler.registerModeOperationOverride(nodeDefinition, from);
        }
    }

    private static final class NaiveOverrideHandler
    implements IOverrideHandler {
        private NaiveOverrideHandler() {
        }

        @Override
        public void registerModeOperationOverride(NodeDefinition nodeDefinition, String from) {
        }
    }
}

