/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Namespace;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.Repository;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.IModuleContributionManager;
import org.mule.tooling.core.module.IModuleHandlerFactory;
import org.mule.tooling.core.module.MuleModule;
import org.mule.tooling.core.module.internal.CategoryModuleHandler;
import org.mule.tooling.core.module.internal.CompositeModuleHandler;
import org.mule.tooling.core.module.internal.GroupModuleHandler;
import org.mule.tooling.core.module.internal.IModuleHandler;
import org.mule.tooling.core.module.internal.ModuleHandlerCache;
import org.mule.tooling.core.module.internal.ReferenceModuleHandler;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;

public class ModuleContributionManager
implements IModuleContributionManager {
    public static final String EXTENSION_ID_MODULE_FACTORY = "org.mule.tooling.core.moduleHandlerFactory";
    public static final String DEFAULT_MODULES_ID = "default";
    private static Object lock = new Object();
    private static volatile ModuleContributionManager instance;
    private final Map<String, IModuleHandler<MuleModule>> muleModuleHandlersById = new ConcurrentHashMap<String, IModuleHandler<MuleModule>>();
    private final Map<String, ModuleHandlerCache> externalModuleHandlersById = new ConcurrentHashMap<String, ModuleHandlerCache>();
    private final Set<String> initializingReferenceModuleIds = new HashSet<String>();
    private CategoryModuleHandler categoryHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IModuleContributionManager getInstance() {
        ModuleContributionManager result = instance;
        if (result == null) {
            Object object = lock;
            synchronized (object) {
                result = instance;
                if (result == null) {
                    instance = result = new ModuleContributionManager();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Object object = lock;
        synchronized (object) {
            instance = null;
        }
    }

    private ModuleContributionManager() {
        this.initDefaultCategoryHandler();
        this.initModuleHandlers();
        this.initReferenceHandlers();
    }

    private List<IConfigurationElement> retrieveContributions(IExtension extension, String contributionType) {
        IConfigurationElement[] configurationElements = extension.getConfigurationElements();
        ArrayList<IConfigurationElement> externalContributions = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String type = configurationElement.getName();
            if (type.equals(contributionType)) {
                externalContributions.add(configurationElement);
            }
            ++n2;
        }
        return externalContributions;
    }

    private void initDefaultCategoryHandler() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.mule.tooling.module");
        this.categoryHandler = new CategoryModuleHandler(Arrays.asList(elements));
    }

    @Override
    public List<MuleModule> getModules(String id) {
        return this.getModules(id, Collections.emptyList());
    }

    @Override
    public void addExternalModuleHandlerCache(IServerDefinition serverDefinition, ModuleHandlerCache moduleHandlerCache) {
        this.externalModuleHandlersById.put(serverDefinition.getId(), moduleHandlerCache);
    }

    private ModuleHandlerCache getServerExternalModulesHandler(IServerDefinition serverDefinition) {
        return this.externalModuleHandlersById.computeIfAbsent(serverDefinition.getId(), id -> new ModuleHandlerCache());
    }

    @Override
    public List<ExternalContributionMuleModule> getModulesFrom(IServerDefinition server) {
        return new ArrayList<ExternalContributionMuleModule>(this.getServerExternalModulesHandler(server).getAll());
    }

    @Override
    public List<MuleModule> getModules(String id, List<String> exclusions) {
        this.checkHandlerExists(id);
        ArrayList<MuleModule> modules = new ArrayList<MuleModule>(this.muleModuleHandlersById.get(id).getModules());
        if (!exclusions.isEmpty()) {
            this.filterWithExclusions(modules, exclusions);
        }
        return modules;
    }

    private void filterWithExclusions(List<MuleModule> modules, List<String> exclusions) {
        Iterator<MuleModule> iterator = modules.iterator();
        while (iterator.hasNext()) {
            MuleModule muleModule = iterator.next();
            if (!exclusions.contains(muleModule.getId())) continue;
            iterator.remove();
        }
    }

    @Override
    public List<ExternalContributionMuleModule> getExternalModules(IServerDefinition server) {
        List<ExternalContributionMuleModule> externalModules = this.getExternalModulesFrom(server);
        String version = server.getVersionWithEESign().replaceAll(";", "");
        return CoreUtils.selectExternalModulesForVersion(version, externalModules);
    }

    @Override
    public List<ExternalContributionMuleModule> getExternalModulesFrom(IServerDefinition server) {
        return this.getModulesFrom(server);
    }

    @Override
    public List<MuleModule> getCategoryModules() {
        return this.categoryHandler.getModules();
    }

    private void initReferenceHandlers() {
        IExtension[] groupsExtensions;
        IExtension[] iExtensionArray = groupsExtensions = this.readContributionGroupsExtensions();
        int n = groupsExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            String identifier = extension.getSimpleIdentifier();
            this.createGroupHandler(extension, identifier);
            ++n2;
        }
    }

    private void createGroupHandler(IExtension extension, String uniqueIdentifier) {
        try {
            if (this.initializingReferenceModuleIds.contains(uniqueIdentifier)) {
                IllegalArgumentException ex = new IllegalArgumentException();
                ex.fillInStackTrace();
                MuleCorePlugin.logError("There is a circular reference between contributionsets. Id: " + uniqueIdentifier, ex);
                return;
            }
            this.initializingReferenceModuleIds.add(uniqueIdentifier);
            ReferenceModuleHandler moduleHandler = new ReferenceModuleHandler(id -> this.getModuleHandler((String)id), uniqueIdentifier, Arrays.asList(extension.getConfigurationElements()));
            this.muleModuleHandlersById.put(uniqueIdentifier, moduleHandler);
        }
        finally {
            this.initializingReferenceModuleIds.remove(uniqueIdentifier);
        }
    }

    private void initModuleHandlers() {
        IExtension[] extensions = this.readContributionExtensions();
        ArrayList<IConfigurationElement> defaultContributions = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            List<IConfigurationElement> coreContributions = this.retrieveContributions(extension, "contribution").stream().collect(Collectors.toList());
            if (!coreContributions.isEmpty()) {
                String uniqueIdentifier = extension.getSimpleIdentifier();
                if (StringUtils.isEmpty((String)uniqueIdentifier)) {
                    defaultContributions.addAll(coreContributions);
                } else {
                    this.addCompositeHandler(uniqueIdentifier, coreContributions);
                }
            }
            ++n2;
        }
        this.addCompositeHandler(DEFAULT_MODULES_ID, defaultContributions);
    }

    private IExtension[] readContributionGroupsExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.mule.tooling.core.contributionset");
        if (extensionPoint == null) {
            throw new RuntimeException("Could not initialize module groups");
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        return extensions;
    }

    private IExtension[] readContributionExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.mule.tooling.core.contribution");
        if (extensionPoint == null) {
            throw new RuntimeException("Could not initialize module managers");
        }
        Object[] extensions = extensionPoint.getExtensions();
        if (ArrayUtils.isEmpty((Object[])extensions)) {
            MuleCorePlugin.logWarning("Couldn't find any contribution modules to load");
        }
        return extensions;
    }

    private void addCompositeHandler(String uniqueIdentifier, List<IConfigurationElement> configurationElements) {
        CompositeModuleHandler moduleHandler = new CompositeModuleHandler(uniqueIdentifier, configurationElements);
        IModuleHandler<MuleModule> existing = this.muleModuleHandlersById.put(uniqueIdentifier, moduleHandler);
        if (existing != null) {
            MuleCorePlugin.logWarning("A clash of module contributions exists with the id: " + uniqueIdentifier);
        }
        for (IModuleHandler singleModuleHandler : moduleHandler.getHandlers()) {
            this.muleModuleHandlersById.put(singleModuleHandler.getUniqueIdentifier(), singleModuleHandler);
        }
    }

    @Override
    public void registerCompositeHandler(String uniqueIdentifier, GroupModuleHandler<MuleModule> moduleHandler) {
        IModuleHandler existing = this.muleModuleHandlersById.put(uniqueIdentifier, moduleHandler);
        if (existing != null) {
            MuleCorePlugin.logWarning("A clash of module contributions exists with the id: " + uniqueIdentifier);
        }
        for (IModuleHandler<MuleModule> singleModuleHandler : moduleHandler.getHandlers()) {
            this.muleModuleHandlersById.put(singleModuleHandler.getUniqueIdentifier(), singleModuleHandler);
        }
    }

    private boolean containsModuleHandler(String moduleHandlerId) {
        return this.muleModuleHandlersById.containsKey(moduleHandlerId);
    }

    private void initializeGroupModuleHandler(String moduleHandlerId) {
        IExtension extension = this.getExtensionFromGroupsExtensions(moduleHandlerId);
        if (extension == null) {
            MuleCorePlugin.logError("Could not initialize group contribution handler", new RuntimeException());
        } else {
            this.createGroupHandler(extension, moduleHandlerId);
        }
    }

    private IExtension getExtensionFromGroupsExtensions(String extensionId) {
        IExtension[] contributionGroups;
        IExtension[] iExtensionArray = contributionGroups = this.readContributionGroupsExtensions();
        int n = contributionGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            String simpleIdentifier = extension.getSimpleIdentifier();
            if (!StringUtils.isEmpty((String)simpleIdentifier) && extensionId.equals(simpleIdentifier)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }

    IModuleHandler<MuleModule> getModuleHandler(String moduleHandlerId) {
        if (!this.containsModuleHandler(moduleHandlerId)) {
            this.initializeGroupModuleHandler(moduleHandlerId);
        }
        return this.muleModuleHandlersById.get(moduleHandlerId);
    }

    private void checkHandlerExists(String id) {
        if (!this.containsModuleHandler(id)) {
            throw new IllegalArgumentException("No handler registerd by the id: " + id);
        }
    }

    @Override
    public Map<String, ExternalContributionMuleModule> getExternalContributionsMappedById(IServerDefinition server) {
        return this.getExternalModules(server).stream().filter(m -> !StringUtils.isEmpty((String)m.getContributionJar())).collect(Collectors.toMap(m -> m.getId(), Function.identity()));
    }

    @Override
    public Set<Namespace> getExternalContributionsNamespaces(IServerDefinition server) {
        return this.getExternalModules(server).stream().map(m -> Namespace.get((String)m.getContributionNamespacePrefix(), (String)m.getContributionNamespace())).collect(Collectors.toSet());
    }

    @Override
    public Optional<ExternalContributionMuleModule> getExternalModule(IServerDefinition serverDefinition, String coords) {
        return Optional.ofNullable(this.externalModuleHandlersById.get(serverDefinition.getId())).map(moduleHandlerCache -> moduleHandlerCache.get(coords));
    }

    @Override
    public ExternalContributionMuleModule getExternalModule(IServerDefinition serverDefinition, MavenDependency dependency2, List<Repository> repositories) {
        ModuleHandlerCache serverCache = this.getServerExternalModulesHandler(serverDefinition);
        String coords = MavenCore.getCoords(dependency2);
        return serverCache.computeIfAbsent(coords, mavenCoords -> this.getModuleFactory().createHandlerFor(serverDefinition.getVersionWithSuffix(), MavenUtils.getPluginDependency(coords), repositories).filter(handler -> !handler.getModules().isEmpty()).orElse(null));
    }

    private IModuleHandlerFactory<ExternalContributionMuleModule> getModuleFactory() {
        List<IModuleHandlerFactory> extensionPointObjects = CoreUtils.getExtensionPointObjects(EXTENSION_ID_MODULE_FACTORY, IModuleHandlerFactory.class);
        if (extensionPointObjects.isEmpty()) {
            throw new RuntimeException("No handler factory");
        }
        return extensionPointObjects.get(0);
    }

    @Override
    public Map<String, Set<ExternalContributionMuleModule>> getAvailableVersions(List<ExternalContributionMuleModule> externalModules, IServerDefinition server) {
        String key;
        MavenDependency dependency2;
        HashMap<String, Set<ExternalContributionMuleModule>> moduleToAvailableVersions = new HashMap<String, Set<ExternalContributionMuleModule>>();
        ModuleHandlerCache moduleHandlerByServer = this.externalModuleHandlersById.get(server.getId());
        if (moduleHandlerByServer == null) {
            return moduleToAvailableVersions;
        }
        Collection<ExternalContributionMuleModule> all = moduleHandlerByServer.getAll();
        for (ExternalContributionMuleModule e : externalModules) {
            dependency2 = MavenUtils.getPluginDependency(e.getId());
            key = MavenUtils.getGA(dependency2);
            HashSet<ExternalContributionMuleModule> versions = new HashSet<ExternalContributionMuleModule>();
            moduleToAvailableVersions.put(key, versions);
            versions.add(e);
        }
        for (ExternalContributionMuleModule module : all) {
            dependency2 = MavenUtils.getPluginDependency(module.getId());
            key = MavenUtils.getGA(dependency2);
            Set<ExternalContributionMuleModule> versionsList = moduleToAvailableVersions.get(key);
            if (versionsList == null || !(module instanceof ExternalContributionMuleModule)) continue;
            versionsList.add(module);
        }
        return moduleToAvailableVersions;
    }

    @Override
    public void addHandlerIfAbsent(IServerDefinition serverDefinition, MavenDependency dependency2, IModuleHandler<ExternalContributionMuleModule> handler) {
        ModuleHandlerCache serverCache = this.getServerExternalModulesHandler(serverDefinition);
        String coords = MavenCore.getCoords(dependency2);
        serverCache.computeIfAbsent(coords, mavenCoords -> handler);
    }
}

