/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FeaturedModulesTracker {
    private final Map<String, State> processingStateByServerId = new ConcurrentHashMap<String, State>(10);

    public static FeaturedModulesTracker instance() {
        return SingletonHolder.INSTANCE;
    }

    private FeaturedModulesTracker() {
    }

    public void setLoadingState(String serverId) {
        this.processingStateByServerId.put(serverId, State.LOADING);
    }

    public void setLoadedState(String serverId) {
        this.processingStateByServerId.put(serverId, State.LOADED);
    }

    public boolean isLoading(String serverId) {
        State state = this.processingStateByServerId.get(serverId);
        return State.LOADING.equals((Object)state);
    }

    public boolean isLoaded(String serverId) {
        State state = this.processingStateByServerId.get(serverId);
        return State.LOADED.equals((Object)state);
    }

    public boolean stateUnknown(String serverId) {
        return !this.processingStateByServerId.containsKey(serverId);
    }

    public void clear() {
        this.processingStateByServerId.clear();
    }

    private static class SingletonHolder {
        private static final FeaturedModulesTracker INSTANCE = new FeaturedModulesTracker();

        private SingletonHolder() {
        }
    }

    public static enum State {
        LOADING,
        LOADED;

    }
}

