/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.module.MuleModule;
import org.mule.tooling.core.module.contribution.ErrorModel;
import org.mule.tooling.core.module.internal.IOverrideHandler;

public class ExternalContributionMuleModule
extends MuleModule {
    private static final String CONNECTOR_NAME_HINT = "-connector-";
    private static final String MODULE_NAME_HINT = "-module-";
    private final MavenCoordinates coordinates;
    private String contributionNamespacePrefix;
    private String contributionNamespace;
    private String contributionNamespaceFile;
    private String contributionLibs;
    private String contributionJar;
    private String contributionSources;
    private String contributionJavaDocs;
    private String contributionLibPathInMule;
    private String contributionVersion;
    private String version;
    private String name;
    private String minimumVersion;
    private String maximumVersion;
    private boolean includeInDesignTimeClasspath;
    private Set<ErrorModel> errorModels = new HashSet<ErrorModel>();
    private Set<MavenDependency> requiredLibraries = new HashSet<MavenDependency>();
    public static final String MAX_VERSION_DEFAULT = "10.0.0";

    public ExternalContributionMuleModule(MavenCoordinates coordinates, MuleModule.ModeOperationOverrideModuleLoaderHandler handlerRef) {
        super(MavenUtils.getGAV(coordinates), handlerRef);
        this.coordinates = coordinates;
    }

    public MavenCoordinates getCoordinates() {
        return this.coordinates;
    }

    public Optional<ModuleType> getType() {
        return Optional.ofNullable(this.getContributionJar()).map(fileName -> {
            ModuleType type = null;
            if (fileName.contains(MODULE_NAME_HINT)) {
                type = ModuleType.MODULE;
            } else if (fileName.contains(CONNECTOR_NAME_HINT)) {
                type = ModuleType.CONNECTOR;
            }
            return type;
        });
    }

    public void setErrorModels(Set<ErrorModel> errorModels) {
        this.errorModels = errorModels;
    }

    public Set<ErrorModel> getErrorModels() {
        return this.errorModels;
    }

    public String getMinimumVersion() {
        return this.minimumVersion;
    }

    public void setMinimumVersion(String minimumVersion) {
        this.minimumVersion = minimumVersion;
    }

    public String getMaximumVersion() {
        return this.maximumVersion;
    }

    public void setMaximumVersion(String maximumVersion) {
        this.maximumVersion = maximumVersion;
    }

    public String getContributionNamespace() {
        return this.contributionNamespace;
    }

    public void setContributionNamespace(String contributingNamespace) {
        this.contributionNamespace = contributingNamespace;
    }

    public String getContributionLibs() {
        return this.contributionLibs;
    }

    public void setContributionLibs(String contributionLibs) {
        this.contributionLibs = contributionLibs;
    }

    public File getContributionJarFile() {
        File libs = this.getLibs();
        if (libs != null && libs.exists()) {
            if (libs.isDirectory()) {
                return new File(libs, this.getContributionJar());
            }
            return libs;
        }
        return null;
    }

    public File getLibs() {
        File lib = null;
        String contributionLibs = this.getContributionLibs();
        if (StringUtils.isBlank((CharSequence)contributionLibs)) {
            return lib;
        }
        try {
            File bundleFile = this.getRoot();
            if (bundleFile != null) {
                String path = bundleFile.getPath() + File.separator + contributionLibs;
                File file = new File(path);
                lib = file.exists() ? file : this.getExtensionZipFile();
            }
        }
        catch (IOException iOException) {}
        return lib;
    }

    public File getExtensionZipFile() throws IOException {
        return this.muleArtifact.getOriginalFile();
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    public String getContributionLibPathInMule() {
        return this.contributionLibPathInMule;
    }

    public void setContributionLibPathInMule(String contributionLibPathInMule) {
        this.contributionLibPathInMule = contributionLibPathInMule;
    }

    public void setContributionNamespacePrefix(String contributionNamespacePrefix) {
        this.contributionNamespacePrefix = contributionNamespacePrefix;
    }

    public String getContributionNamespacePrefix() {
        return this.contributionNamespacePrefix;
    }

    public void setContributionNamespaceFile(String contributionNamespaceFile) {
        this.contributionNamespaceFile = contributionNamespaceFile;
    }

    public String getContributionNamespaceFile() {
        return this.contributionNamespaceFile;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String getContributionJar() {
        return this.contributionJar;
    }

    public void setContributionJar(String contributionJar) {
        this.contributionJar = contributionJar;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.getName() + this.getType().map(type -> " " + type.getLabel()).orElse("");
    }

    public String getContributionSources() {
        return this.contributionSources;
    }

    public void setContributionSources(String contributionSources) {
        this.contributionSources = contributionSources;
    }

    public String getContributionJavaDocs() {
        return this.contributionJavaDocs;
    }

    public void setContributionJavaDocs(String contributionJavaDocs) {
        this.contributionJavaDocs = contributionJavaDocs;
    }

    public String getContributionVersion() {
        return this.contributionVersion;
    }

    public void setContributionVersion(String contributionVersion) {
        this.contributionVersion = contributionVersion;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExternalContributionMuleModule other = (ExternalContributionMuleModule)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    @Override
    public String toString() {
        return "ExternalContributionMuleModule [name=" + this.name + ", id=" + this.getId() + "]";
    }

    public boolean isIncludeInDesignTimeClasspath() {
        return this.includeInDesignTimeClasspath;
    }

    public void setIncludeInDesignedTimeClasspath(boolean includeInDesignTimeClasspath) {
        this.includeInDesignTimeClasspath = includeInDesignTimeClasspath;
    }

    public Set<MavenDependency> getRequiredLibraries() {
        return this.requiredLibraries;
    }

    public void setRequiredLibraries(Set<MavenDependency> requiredLibraries) {
        this.requiredLibraries = requiredLibraries;
    }

    public static class ExternalModeOperationOverrideModuleLoaderHandler
    extends MuleModule.ModeOperationOverrideModuleLoaderHandler {
        public ExternalModeOperationOverrideModuleLoaderHandler(IOverrideHandler moduleHandler) {
            super(moduleHandler);
        }
    }

    public static enum ModuleType {
        MODULE("Module"),
        CONNECTOR("Connector");

        private String label;

        private ModuleType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

