/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.model;

import java.util.Iterator;
import org.mule.tooling.core.Category;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.decorator.ContainerDecorator;
import org.mule.tooling.model.messageflow.decorator.EndpointDecorator;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.model.messageflow.util.NodeDefinitionVisitorAdapter;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;

public class ResponseNodeUtils {
    public static void removeResponseDefinition(Iterable<? extends NodeDefinition> definitions) {
        final Iterator<? extends NodeDefinition> iterator = definitions.iterator();
        while (iterator.hasNext()) {
            iterator.next().accept(new NodeDefinitionVisitorAdapter(){

                @Override
                public void visitContainerDefinition(ContainerDefinition containerDefinition) {
                    if ("http://www.mulesoft.org/schema/mule/core/response".equals(containerDefinition.getId())) {
                        iterator.remove();
                    }
                }
            });
        }
    }

    public static boolean isRequestResponse(IMessageFlowEntity node) {
        if (node instanceof IMessageFlowNode) {
            RequestResponseChecker requestResponseChecker = new RequestResponseChecker();
            node.accept(requestResponseChecker);
            return requestResponseChecker.isRequestResponse();
        }
        return false;
    }

    public static boolean isResponseParticipant(MessageFlowEntity node) {
        if (node instanceof EndpointNode) {
            EndpointNode endpoint = (EndpointNode)node;
            EndpointDecorator decorator = new EndpointDecorator(endpoint);
            return decorator.isResponseParticipant();
        }
        if (node instanceof PatternNode) {
            PatternNode patternNode = (PatternNode)node;
            PatternDefinition definition = (PatternDefinition)patternNode.getDefinition();
            return definition.isProcessesResponse();
        }
        return false;
    }

    public static boolean isValidResponseSource(EntityDecorator<?> decorator) {
        if (decorator == null) {
            return false;
        }
        Object flowEntity = decorator.getEntity();
        if (!(flowEntity instanceof MessageFlowNode)) {
            return false;
        }
        if (ModelUtils.isComment(flowEntity)) {
            return true;
        }
        MessageFlowNode node = (MessageFlowNode)flowEntity;
        String type = node.getType();
        NodeDefinition definition = node.getDefinition();
        return ResponseNodeUtils.isValidResponseSourceNode(decorator, node, type) || ResponseNodeUtils.isValidResponseSourceCategory(definition);
    }

    private static boolean isValidResponseSourceNode(EntityDecorator<?> decorator, MessageFlowNode node, String type) {
        boolean isRREndpoint = decorator instanceof EndpointDecorator && ((EndpointDecorator)decorator).isRequestResponseMEP();
        boolean isSplitter = type == null && node instanceof SplitterNode;
        boolean isScope = decorator instanceof ContainerDecorator;
        boolean isAsyncScope = ModelUtils.isAsyncScope(decorator);
        return isSplitter || isRREndpoint || isScope && !isAsyncScope;
    }

    private static boolean isValidResponseSourceCategory(NodeDefinition definition) {
        String categoryId = definition.getCategoryId();
        if (definition == null || categoryId == null) {
            return false;
        }
        return categoryId.equals(Category.CLOUD_CONNECTORS.getCategoryString()) || categoryId.equals(Category.FLOW_CONTROL.getCategoryString()) || categoryId.equals(Category.FILTERS.getCategoryString()) || definition instanceof PatternDefinition;
    }

    private static class RequestResponseChecker
    extends MessageFlowEntityVisitorAdapter {
        private boolean isRequestResponse = false;

        private RequestResponseChecker() {
        }

        @Override
        public void visitEndpointNode(EndpointNode endpointNode) {
            EndpointDecorator decorator = new EndpointDecorator(endpointNode);
            this.isRequestResponse = decorator.isRequestResponseMEP();
        }

        @Override
        public void visitPatternNode(PatternNode patternNode) {
            PatternDefinition definition = (PatternDefinition)patternNode.getDefinition();
            this.isRequestResponse = definition.isProcessesResponse();
        }

        public boolean isRequestResponse() {
            return this.isRequestResponse;
        }
    }
}

