/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.model;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.deployer.DeploymentHelper;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;

public interface MuleProjectKind<T> {
    public static final MuleProjectKind<IMuleApplicationProject> APPLICATION = new MuleProjectKind<IMuleApplicationProject>(){

        @Override
        public boolean classifies(IProject muleProject) throws CoreException {
            boolean hasMuleDomainNature = CoreUtils.hasMuleDomainNature(muleProject);
            boolean hasMuleNature = CoreUtils.hasMuleNature(muleProject);
            return !hasMuleDomainNature && hasMuleNature;
        }

        @Override
        public File getDestinationMuleFolder(IMuleProject muleProject) {
            IServerDefinition serverDefinition = muleProject.getServerDefinition();
            return this.adapt(muleProject).hasDefaultDomain() ? DeploymentHelper.getMuleAppsFolder(serverDefinition) : DeploymentHelper.getMuleDomainsFolder(serverDefinition);
        }

        @Override
        public String getDestinationAgentPath() {
            return "applications";
        }

        @Override
        public boolean classifies(IMuleProject muleProject) {
            return muleProject != null && this.equals(muleProject.getKind());
        }

        @Override
        public IMuleApplicationProject adapt(IMuleProject muleProject) {
            if (!this.classifies(muleProject)) {
                throw new IllegalArgumentException("Project " + String.valueOf(muleProject) + " cannot be adapted to " + String.valueOf(this));
            }
            return (IMuleApplicationProject)muleProject;
        }

        @Override
        public IMuleApplicationProject adapt(IProject muleProject) {
            try {
                if (!this.classifies(muleProject)) {
                    throw new IllegalArgumentException("Project " + String.valueOf(muleProject) + " cannot be adapted to " + String.valueOf(this));
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            return (IMuleApplicationProject)muleProject.getAdapter(IMuleProject.class);
        }

        @Override
        public String getXmlRootNodeName() {
            return "mule";
        }

        public String toString() {
            return "APPLICATION Project Kind";
        }
    };
    public static final MuleProjectKind<IMuleDomainProject> DOMAIN = new MuleProjectKind<IMuleDomainProject>(){

        public String toString() {
            return "DOMAIN Project Kind";
        }

        @Override
        public boolean classifies(IProject muleProject) throws CoreException {
            return CoreUtils.hasMuleDomainNature(muleProject);
        }

        @Override
        public File getDestinationMuleFolder(IMuleProject muleProject) {
            return DeploymentHelper.getMuleDomainsFolder(muleProject.getServerDefinition());
        }

        @Override
        public String getDestinationAgentPath() {
            return "domains";
        }

        @Override
        public boolean classifies(IMuleProject muleProject) {
            return this.equals(muleProject.getKind());
        }

        @Override
        public IMuleDomainProject adapt(IMuleProject muleProject) {
            if (!this.classifies(muleProject)) {
                throw new IllegalArgumentException("Project " + String.valueOf(muleProject) + " cannot be adapted to " + String.valueOf(this));
            }
            return (IMuleDomainProject)muleProject;
        }

        @Override
        public IMuleDomainProject adapt(IProject project) {
            try {
                if (!this.classifies(project)) {
                    throw new IllegalArgumentException("Project " + String.valueOf(project) + " cannot be adapted to " + String.valueOf(this));
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            return (IMuleDomainProject)project.getAdapter(IMuleProject.class);
        }

        @Override
        public String getXmlRootNodeName() {
            return "domain:mule-domain";
        }
    };

    public boolean classifies(IProject var1) throws CoreException;

    public File getDestinationMuleFolder(IMuleProject var1);

    public String getDestinationAgentPath();

    public boolean classifies(IMuleProject var1);

    public T adapt(IMuleProject var1);

    public T adapt(IProject var1);

    public String getXmlRootNodeName();
}

