/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.model;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleProjectComponent;
import org.mule.tooling.core.model.IMuleProjectComponentFactory;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

@Singleton
public class MuleProjectComponentManager {
    private final List<IMuleProjectComponentFactory> factories;
    private Map<IProject, Map<Class<? extends IMuleProjectComponent>, IMuleProjectComponent>> componentsByProject;
    private EventBus eventBus;

    public static Optional<MuleProjectComponentManager> retrieveIfActive() {
        if (!MuleCorePlugin.getContextValue(EventBus.class).isPresent()) {
            return Optional.empty();
        }
        return Optional.of(MuleProjectComponentManager.getInstance());
    }

    public static MuleProjectComponentManager getInstance() {
        return EclipseContextHelper.createFromStudioContext(MuleProjectComponentManager.class);
    }

    @Inject
    public MuleProjectComponentManager(EventBus eventBus) {
        this.eventBus = eventBus;
        this.factories = this.getExtensions().stream().map(MuleProjectComponentExtension::getFactory).collect(Collectors.toList());
        this.componentsByProject = new HashMap<IProject, Map<Class<? extends IMuleProjectComponent>, IMuleProjectComponent>>();
        this.eventBus.registerListener(CoreEventTypes.ResourceEvents.ON_MULE_PROJECT_EVENT, (IEventHandler)new IMuleProjectEventListener(){

            @Override
            public void onMuleProjectOpened(IProject project) {
            }

            @Override
            public void onMuleProjectClosed(IProject project) {
            }

            @Override
            public void onMuleProjectPreClose(IMuleProject muleProject) {
                Map<Class<? extends IMuleProjectComponent>, IMuleProjectComponent> componentsMap = MuleProjectComponentManager.this.componentsByProject.get(muleProject.getProject());
                if (componentsMap != null) {
                    MuleProjectComponentManager.this.stopComponents(componentsMap);
                    MuleProjectComponentManager.this.componentsByProject.remove(muleProject.getProject());
                }
            }
        });
    }

    public void stop() {
        try {
            this.componentsByProject.values().forEach(this::stopComponents);
        }
        catch (Throwable ex) {
            MuleCorePlugin.logError("Unexpected error terminating " + this.getClass().getName(), ex);
        }
    }

    private void stopComponents(Map<Class<? extends IMuleProjectComponent>, IMuleProjectComponent> componentsMap) {
        Collection<IMuleProjectComponent> components = componentsMap.values();
        for (IMuleProjectComponent component : components) {
            try {
                component.stop();
            }
            catch (Throwable ex) {
                MuleCorePlugin.logError("Unexpected error terminating component " + component.getClass().getName(), ex);
            }
        }
    }

    protected List<MuleProjectComponentExtension> getExtensions() {
        return IExtensionPointReader.create(MuleProjectComponentExtension.class).readAll();
    }

    public <T extends IMuleProjectComponent> T getComponent(IMuleProject project, Class<T> componentType) {
        Map<Class<? extends IMuleProjectComponent>, IMuleProjectComponent> components = this.componentsByProject.get(project.getProject());
        if (components != null) {
            IMuleProjectComponent theComponent = components.get(componentType);
            if (theComponent != null) {
                return (T)((IMuleProjectComponent)componentType.cast(theComponent));
            }
            return this.initComponent(project, componentType);
        }
        this.componentsByProject.put(project.getProject(), new HashMap());
        return this.initComponent(project, componentType);
    }

    private <T extends IMuleProjectComponent> T initComponent(IMuleProject project, Class<T> componentType) {
        Map<Class<? extends IMuleProjectComponent>, IMuleProjectComponent> components = this.componentsByProject.get(project.getProject());
        Optional<IMuleProjectComponent> mayBeComponent = this.factories.stream().filter(factory -> factory.type().equals(componentType)).map(factory -> {
            IMuleProjectComponent component = factory.create(project);
            component.init();
            return component;
        }).findFirst();
        if (mayBeComponent.isPresent()) {
            components.put(componentType, mayBeComponent.get());
            return (T)((IMuleProjectComponent)componentType.cast(mayBeComponent.get()));
        }
        return null;
    }

    @ExtensionPoint(extensionPointId="org.mule.tooling.core.projectComponent")
    public static class MuleProjectComponentExtension {
        @ExtensionAttribute(attributeName="class")
        private IMuleProjectComponentFactory factory;

        public IMuleProjectComponentFactory getFactory() {
            return this.factory;
        }

        public void setFactory(IMuleProjectComponentFactory factory) {
            this.factory = factory;
        }
    }
}

