/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.model;

import java.util.Iterator;
import java.util.List;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.utils.ObjectHolder;

public class MuleConfigurationEntityLocator {
    public static GlobalElement locateGlobal(String entityId, MuleConfiguration config) {
        for (IMessageFlowEntity e : config.getGlobalEntries()) {
            IMessageFlowEntity located = e;
            if (!located.getEntityId().equalsIgnoreCase(entityId) || !(located instanceof GlobalElement)) continue;
            return (GlobalElement)located;
        }
        return null;
    }

    public static IMessageFlowEntity locate(String entityId, MuleConfiguration config) {
        for (Container flow : config.getFlows()) {
            if (flow.getEntityId() != null && flow.getEntityId().equals(entityId)) {
                return flow;
            }
            IMessageFlowEntity located = MuleConfigurationEntityLocator.locate(entityId, flow);
            if (located == null) continue;
            return located;
        }
        return null;
    }

    public static IMessageFlowEntity locate(String entityId, Container flow) {
        for (CompartmentLane lane : flow.getLanes()) {
            IMessageFlowEntity located = MuleConfigurationEntityLocator.locate(entityId, lane);
            if (located == null) continue;
            return located;
        }
        return null;
    }

    public static IMessageFlowEntity locate(String entityId, CompartmentLane lane) {
        return MuleConfigurationEntityLocator.locateInCompartmentLineEntries(entityId, lane.getCompartmentLaneEntries());
    }

    private static IMessageFlowEntity locateInCompartmentLineEntries(final String entityId, List<IMessageFlowEntity> entries) {
        Iterator<IMessageFlowEntity> iterator = entries.iterator();
        while (iterator.hasNext()) {
            IMessageFlowEntity entry;
            IMessageFlowEntity entity = entry = iterator.next();
            if (entityId != null && entityId.equals(entity.getEntityId())) {
                return entity;
            }
            final ObjectHolder located = new ObjectHolder();
            entity.accept(new MessageFlowEntityVisitorAdapter(){

                @Override
                public void visitContainer(Container container) {
                    located.set((Object)MuleConfigurationEntityLocator.locateInCompartment(entityId, container));
                }

                @Override
                public void visitCompartmentLane(CompartmentLane lane) {
                    MuleConfigurationEntityLocator.locateInCompartmentLineEntries(entityId, lane.getCompartmentLaneEntries());
                }

                @Override
                public void visitNestedContainer(NestedContainer nestedContainer) {
                    MuleConfigurationEntityLocator.locateInCompartmentLineEntries(entityId, nestedContainer.getCompartmentLaneEntries());
                }

                @Override
                public void visitSplitterNode(SplitterNode splitterNode) {
                    located.set((Object)MuleConfigurationEntityLocator.locateInCompartment(entityId, splitterNode.getCompartment()));
                }
            });
            if (located.isNull()) continue;
            return (IMessageFlowEntity)located.get();
        }
        return null;
    }

    private static IMessageFlowEntity locateInCompartment(String entityId, Compartment compartment) {
        List<CompartmentLane> scopeLanes = compartment.getLanes();
        for (CompartmentLane scopeLane : scopeLanes) {
            IMessageFlowEntity located = MuleConfigurationEntityLocator.locate(entityId, scopeLane);
            if (located == null) continue;
            return located;
        }
        return null;
    }
}

