/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.model;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.impl.model.DomainMavenDependencyComparator;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.model.project.IMuleProjectModel;
import org.mule.tooling.model.project.MuleExtension;

public interface IMuleDomain {
    default public List<IMuleApplicationProject> getChildProjects() throws CoreException {
        List<IMuleApplicationProject> muleProjects = MuleRuntime.getMuleApplicationProjects();
        return muleProjects.stream().filter(muleApp -> DomainMavenDependencyComparator.correspondsTo(muleApp.getDomainCoordinates(), Optional.of(this.getMavenCoordinates()))).collect(Collectors.toList());
    }

    default public boolean isDefault() {
        return this.getMavenCoordinates() == null;
    }

    public boolean isExternal();

    public boolean isValid();

    public String getDomainName();

    public MavenDependency getMavenCoordinates();

    public IServerDefinition getServerDefinition();

    public IMuleProjectModel getMuleProjectModel();

    public List<MuleExtension> getMuleExtensions();
}

