/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.model;

import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.auth.AuthenticationEventTypes;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.exchange.client.ExternalServiceCallException;
import org.mule.tooling.exchange.client.GraphServiceClient;
import org.mule.tooling.exchange.client.GraphServiceQueryBuilder;
import org.mule.tooling.exchange.client.GraphServiceResponse;
import org.mule.tooling.exchange.preferences.ExchangePreferences;
import org.mule.tooling.utils.eventbus.EventBusHelper;

@Singleton
public class DependencyToAssetCache {
    private Map<MavenDependency, GraphServiceCallResult> dependencyToAsset = new ConcurrentHashMap<MavenDependency, GraphServiceCallResult>();
    private ExecutorService fixedThreadPool = Executors.newFixedThreadPool(3);

    public DependencyToAssetCache() {
        new EventBusHelper().registerListener(MuleCorePlugin.getEventBus(), AuthenticationEventTypes.ON_CURRENT_USER_CHANGED, user -> this.invalidate());
    }

    public static DependencyToAssetCache instance() {
        return EclipseContextHelper.createFromStudioContext(DependencyToAssetCache.class);
    }

    public void invalidate() {
        this.dependencyToAsset.clear();
    }

    public CompletableFuture<GraphServiceCallResult> getAssetFrom(MavenDependency dependency2) {
        return this.getAssetFrom(dependency2, GraphServiceClient.AssetType.REST_API);
    }

    public CompletableFuture<GraphServiceCallResult> getFragmentAssetFrom(MavenDependency dependency2) {
        return this.getAssetFrom(dependency2, GraphServiceClient.AssetType.RAML_FRAGMENT);
    }

    private CompletableFuture<GraphServiceCallResult> getAssetFrom(MavenDependency dependency2, GraphServiceClient.AssetType ... assetTypes) {
        if (this.dependencyToAsset.containsKey(dependency2)) {
            return CompletableFuture.completedFuture(this.dependencyToAsset.get(dependency2));
        }
        return CompletableFuture.supplyAsync(() -> this.getAssetFromExchange(dependency2, assetTypes), this.fixedThreadPool);
    }

    public static GraphServiceClient getGraphServiceClient() {
        return GraphServiceClient.create(PlatformUrls.getActiveGraphServiceUrl(), DependencyToAssetCache.getAccessToken());
    }

    private static Optional<String> getAccessToken() {
        AuthUser activeAuthUser = CoreUtils.getLoginManager().retrieveActiveAuthUser();
        return Optional.ofNullable(activeAuthUser).filter(user -> CoreUtils.getLoginManager().isTokenValid((AuthUser)user).succeeded()).map(AuthUser::getToken);
    }

    public GraphServiceCallResult getAssetFromExchange(MavenDependency dependency2, GraphServiceClient.AssetType ... assetTypes) {
        GraphServiceCallResult graphServiceCallResult;
        GraphServiceCallResult result = null;
        try {
            GraphServiceQueryBuilder queryBuilder = GraphServiceQueryBuilder.create().withCoordinates(dependency2.getGroupId(), dependency2.getArtifactId()).includeSnapshots(ExchangePreferences.includeSnapshots()).withAssetTypes(assetTypes).build();
            GraphServiceResponse<ExchangeAsset> searchByCoordinates = DependencyToAssetCache.getGraphServiceClient().search(queryBuilder, Optional.empty());
            Optional<ExchangeAsset> candidate = searchByCoordinates.getElements().stream().filter(asset -> asset.getVersion().equals(dependency2.getVersion())).findFirst();
            result = candidate.isPresent() ? GraphServiceCallResult.responseOkWithAsset(candidate.get()) : GraphServiceCallResult.responseOkWithoutAsset();
            graphServiceCallResult = result;
            this.dependencyToAsset.put(dependency2, result);
        }
        catch (ExternalServiceCallException e) {
            GraphServiceCallResult graphServiceCallResult2;
            try {
                MuleCorePlugin.logWarning("Failed to retrieve exchange asset: " + e.getMessage(), e);
                graphServiceCallResult2 = result = GraphServiceCallResult.responseFailedWithException(e);
                this.dependencyToAsset.put(dependency2, result);
            }
            catch (Throwable throwable) {
                this.dependencyToAsset.put(dependency2, result);
                throw throwable;
            }
            return graphServiceCallResult2;
        }
        return graphServiceCallResult;
    }

    public static final class GraphServiceCallResult {
        private boolean failed = true;
        private Optional<Exception> exception = Optional.empty();
        private Optional<ExchangeAsset> asset = Optional.empty();

        private GraphServiceCallResult(Exception e) {
            this.exception = Optional.of(e);
            this.failed = true;
        }

        private GraphServiceCallResult(ExchangeAsset exchangeAsset) {
            this.asset = Optional.ofNullable(exchangeAsset);
            this.failed = false;
        }

        private GraphServiceCallResult() {
            this.failed = false;
        }

        public static GraphServiceCallResult responseFailedWithException(Exception e) {
            return new GraphServiceCallResult(e);
        }

        public static GraphServiceCallResult responseOkWithAsset(ExchangeAsset exchangeAsset) {
            return new GraphServiceCallResult(exchangeAsset);
        }

        public static GraphServiceCallResult responseOkWithoutAsset() {
            return new GraphServiceCallResult();
        }

        public boolean isOk() {
            return !this.failed;
        }

        public Optional<Exception> getException() {
            return this.exception;
        }

        public Optional<ExchangeAsset> getExchangeAsset() {
            return this.asset;
        }
    }
}

