/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.meta;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.meta.DesignInformation;
import org.mule.tooling.core.model.IMuleProject;

public class DesignInformationUtils {
    private static final String SAMPLE_DATA_FOLDER_NAME = "sample_data";

    private DesignInformationUtils() {
    }

    public static Optional<DesignInformation> loadFrom(IMuleProject muleProject) {
        IFile file;
        IFolder folder;
        IFolder testResourcesFolder = DesignInformationUtils.testResourcesFolder(muleProject);
        if (testResourcesFolder.isAccessible() && (folder = testResourcesFolder.getFolder(SAMPLE_DATA_FOLDER_NAME)).isAccessible() && (file = folder.getFile("design-info.json")).exists()) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream is = file.getContents();){
                    BufferedReader buf = new BufferedReader(new InputStreamReader(is));
                    Gson gson = new Gson();
                    return Optional.ofNullable((DesignInformation)gson.fromJson((Reader)buf, DesignInformation.class));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (JsonSyntaxException | IOException | CoreException e) {
                MuleCorePlugin.logWarning("Unexpected error loading design information file", e);
            }
        }
        return Optional.empty();
    }

    public static void saveTo(IMuleProject muleProject, DesignInformation designInformation) {
        IFolder testResourcesFolder = DesignInformationUtils.testResourcesFolder(muleProject);
        if (testResourcesFolder.isAccessible()) {
            IFolder folder = testResourcesFolder.getFolder(SAMPLE_DATA_FOLDER_NAME);
            IFile file = folder.getFile("design-info.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String jsonDesignInfo = gson.toJson((Object)designInformation);
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                if (!folder.exists()) {
                    folder.create(true, true, (IProgressMonitor)monitor);
                }
                if (!file.exists()) {
                    file.create((InputStream)new ByteArrayInputStream(jsonDesignInfo.getBytes()), true, (IProgressMonitor)monitor);
                } else {
                    file.setContents((InputStream)new ByteArrayInputStream(jsonDesignInfo.getBytes()), true, false, (IProgressMonitor)monitor);
                }
                folder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                MuleCorePlugin.logWarning("Unexpected error saving design information file", e);
            }
        }
    }

    private static IFolder testResourcesFolder(IMuleProject muleProject) {
        return muleProject.getFolder("src/test/resources");
    }
}

