/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.mel.partitioner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtension;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionManager;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensions;
import org.mule.tooling.core.mel.partitioner.EvaluatorResult;

public class MELDocumentPartitioner
implements IDocumentPartitioner {
    public static final String MEL_EVALUATOR = "mel";
    private static final Pattern EXPRESSION_EVALUATOR_PATTERN = Pattern.compile("^mel:{1}.*$");
    private static final Pattern EXPRESSION_EVALUATOR_GROUPS_PATTERN = Pattern.compile("^(mel):{1}(.*)$");
    public static final String MEL_CONTENT_TYPE = "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.MEL_CONTENT_TYPE";
    public static final String EXPRESSION_BRACKETS_CONTENT_TYPE = "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EXPRESSION_BRACKETS_CONTENT_TYPE";
    public static final String EVALUATOR_CONTENT_TYPE = "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EVALUATOR_CONTENT_TYPE";
    public static final String EVALUATOR_DECLARATION_CONTENT_TYPE = "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EVALUATOR_DECLARATION_CONTENT_TYPE";
    public static final String EVALUATOR_COLON_CONTENT_TYPE = "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EVALUATOR_COLON_CONTENT_TYPE";
    private IDocument document;
    private String content;
    private List<ITypedRegion> regions;
    private int pos;
    private final EvaluatorExtensions extensions;

    public MELDocumentPartitioner() {
        this("", EvaluatorExtensionManager.getInstance().getEvaluators());
    }

    public MELDocumentPartitioner(String content) {
        this(content, EvaluatorExtensionManager.getInstance().getEvaluators());
    }

    public MELDocumentPartitioner(String content, EvaluatorExtensions extensions) {
        this.content = content;
        this.regions = new ArrayList<ITypedRegion>();
        this.extensions = extensions;
    }

    public void connect(IDocument documentToConnect) {
        this.document = documentToConnect;
        this.document.setDocumentPartitioner((IDocumentPartitioner)this);
        this.content = this.document.get();
        this.regions = this.computeRegions();
    }

    public void disconnect() {
        this.document.setDocumentPartitioner(null);
        this.document = null;
        this.content = null;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        this.content = this.document.get();
        List<ITypedRegion> computedRegions = this.computeRegions();
        boolean regionsChanged = this.regionsChanged(this.regions, computedRegions);
        this.regions = computedRegions;
        return regionsChanged;
    }

    public String[] getLegalContentTypes() {
        return new String[]{"__dftl_partition_content_type", MEL_CONTENT_TYPE, EXPRESSION_BRACKETS_CONTENT_TYPE, EVALUATOR_COLON_CONTENT_TYPE, EVALUATOR_CONTENT_TYPE, EVALUATOR_DECLARATION_CONTENT_TYPE};
    }

    public String getContentType(int offset) {
        ITypedRegion partition = this.getPartition(offset);
        if (partition != null) {
            return partition.getType();
        }
        return "__dftl_partition_content_type";
    }

    public ITypedRegion getPartition(int offset) {
        if (offset > this.content.length()) {
            return null;
        }
        if (CollectionUtils.isEmpty(this.regions)) {
            this.regions = this.computeRegions();
        }
        ITypedRegion foundRegion = null;
        for (ITypedRegion region : this.regions) {
            if (region.getOffset() > offset || region.getLength() + region.getOffset() < offset || foundRegion != null && region.getOffset() >= foundRegion.getOffset()) continue;
            foundRegion = region;
        }
        if (foundRegion != null) {
            return foundRegion;
        }
        return new TypedRegion(0, this.document.getLength(), "__dftl_partition_content_type");
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        List<ITypedRegion> computeRegions = this.computeRegions(offset, length);
        return computeRegions.toArray(new ITypedRegion[computeRegions.size()]);
    }

    private List<ITypedRegion> computeRegions() {
        List<ITypedRegion> computedRegions = this.computeRegions(0, this.content.length());
        return computedRegions;
    }

    private boolean regionsChanged(List<ITypedRegion> r1, List<ITypedRegion> r2) {
        return !CollectionUtils.isEqualCollection(r1, r2);
    }

    private List<ITypedRegion> computeRegions(int offset, int length) {
        ArrayList<ITypedRegion> computedRegions = new ArrayList<ITypedRegion>();
        if (StringUtils.isEmpty((String)this.content) || offset < 0 || length <= 0 || offset + length > this.content.length()) {
            return Collections.emptyList();
        }
        String text = this.content.substring(offset, offset + length);
        PartitionerState state = new DefaultRegionState();
        this.pos = offset;
        while (this.pos < length) {
            state = state.processChar(text, computedRegions);
            ++this.pos;
        }
        return computedRegions;
    }

    private boolean nextCharIs(String text, int i, char c) {
        return i < text.length() - 1 && text.charAt(i + 1) == c;
    }

    private boolean isLastPosition(int pos, String text) {
        return pos + 1 == text.length();
    }

    private boolean isExpressionEvaluator(String text, int pos) {
        boolean startWithExpressionEvaluator = EXPRESSION_EVALUATOR_PATTERN.matcher(text.substring(pos + 2)).matches();
        return startWithExpressionEvaluator;
    }

    private class DefaultRegionState
    implements PartitionerState {
        private int beginOffset = -1;
        private int length = 0;

        private DefaultRegionState() {
        }

        @Override
        public PartitionerState processChar(String text, List<ITypedRegion> computedRegions) {
            if (this.beginOffset == -1) {
                this.beginOffset = MELDocumentPartitioner.this.pos;
            }
            char currentChar = text.charAt(MELDocumentPartitioner.this.pos);
            switch (currentChar) {
                case '#': {
                    if (MELDocumentPartitioner.this.nextCharIs(text, MELDocumentPartitioner.this.pos, '[') && !MELDocumentPartitioner.this.isExpressionEvaluator(text, MELDocumentPartitioner.this.pos)) {
                        if (this.length > 0) {
                            computedRegions.add((ITypedRegion)new TypedRegion(this.beginOffset, this.length, "__dftl_partition_content_type"));
                        }
                        computedRegions.add((ITypedRegion)new TypedRegion(MELDocumentPartitioner.this.pos, 2, MELDocumentPartitioner.EXPRESSION_BRACKETS_CONTENT_TYPE));
                        ++MELDocumentPartitioner.this.pos;
                        if (MELDocumentPartitioner.this.isLastPosition(MELDocumentPartitioner.this.pos, text)) {
                            computedRegions.add((ITypedRegion)new TypedRegion(MELDocumentPartitioner.this.pos + 1, 1, MELDocumentPartitioner.MEL_CONTENT_TYPE));
                        }
                        return new MELTokenizerState();
                    }
                    if (!MELDocumentPartitioner.this.nextCharIs(text, MELDocumentPartitioner.this.pos, '[') || !MELDocumentPartitioner.this.isExpressionEvaluator(text, MELDocumentPartitioner.this.pos)) break;
                    if (this.length > 0) {
                        computedRegions.add((ITypedRegion)new TypedRegion(this.beginOffset, this.length, "__dftl_partition_content_type"));
                    }
                    computedRegions.add((ITypedRegion)new TypedRegion(MELDocumentPartitioner.this.pos, 2, MELDocumentPartitioner.EXPRESSION_BRACKETS_CONTENT_TYPE));
                    ++MELDocumentPartitioner.this.pos;
                    return new EvaluatorTokenizerState();
                }
                default: {
                    ++this.length;
                    if (!MELDocumentPartitioner.this.isLastPosition(MELDocumentPartitioner.this.pos, text)) break;
                    computedRegions.add((ITypedRegion)new TypedRegion(this.beginOffset, this.length, "__dftl_partition_content_type"));
                }
            }
            return this;
        }
    }

    private class EvaluatorTokenizerState
    implements PartitionerState {
        private int beginOffset = -1;

        private EvaluatorTokenizerState() {
        }

        @Override
        public PartitionerState processChar(String text, List<ITypedRegion> computedRegions) {
            Matcher evaluatorMatcher;
            if (this.beginOffset == -1) {
                this.beginOffset = MELDocumentPartitioner.this.pos;
            }
            if ((evaluatorMatcher = EXPRESSION_EVALUATOR_GROUPS_PATTERN.matcher(text.substring(MELDocumentPartitioner.this.pos))).find()) {
                String evaluatorIdentifier = evaluatorMatcher.group(1);
                String restOfTheText = evaluatorMatcher.group(2);
                Optional<EvaluatorExtension> maybeExtension = MELDocumentPartitioner.this.extensions.findExtensionForEvaluator(evaluatorIdentifier);
                if (!maybeExtension.isPresent()) {
                    return new MELTokenizerState();
                }
                EvaluatorResult result = maybeExtension.get().partition(restOfTheText);
                int expressionLength = result.getExpression().length();
                int evaluatorIdentifierLength = evaluatorIdentifier.length();
                computedRegions.add((ITypedRegion)new TypedRegion(this.beginOffset, evaluatorIdentifierLength, MELDocumentPartitioner.EVALUATOR_DECLARATION_CONTENT_TYPE));
                computedRegions.add((ITypedRegion)new TypedRegion(this.beginOffset + evaluatorIdentifierLength, 1, MELDocumentPartitioner.EVALUATOR_COLON_CONTENT_TYPE));
                computedRegions.add((ITypedRegion)new TypedRegion(this.beginOffset + evaluatorIdentifierLength + 1, expressionLength, MELDocumentPartitioner.EVALUATOR_CONTENT_TYPE));
                if (text.length() > MELDocumentPartitioner.this.pos + evaluatorIdentifierLength + 1 + expressionLength && text.charAt(MELDocumentPartitioner.this.pos + evaluatorIdentifierLength + 1 + expressionLength) == ']') {
                    computedRegions.add((ITypedRegion)new TypedRegion(this.beginOffset + evaluatorIdentifierLength + 1 + expressionLength, 1, MELDocumentPartitioner.EXPRESSION_BRACKETS_CONTENT_TYPE));
                    MELDocumentPartitioner.this.pos += evaluatorIdentifierLength + 1 + expressionLength + 1;
                } else {
                    MELDocumentPartitioner.this.pos += evaluatorIdentifierLength + 1 + expressionLength;
                }
            }
            return new DefaultRegionState();
        }
    }

    private class MELTokenizerState
    implements PartitionerState {
        private int beginOffset = -1;
        private int length = 0;
        private int bracketLevel = 0;

        private MELTokenizerState() {
        }

        @Override
        public PartitionerState processChar(String text, List<ITypedRegion> computedRegions) {
            if (this.beginOffset == -1) {
                this.beginOffset = MELDocumentPartitioner.this.pos;
            }
            char currentChar = text.charAt(MELDocumentPartitioner.this.pos);
            switch (currentChar) {
                case '[': {
                    ++this.length;
                    ++this.bracketLevel;
                    break;
                }
                case ']': {
                    if (this.bracketLevel == 0) {
                        computedRegions.add((ITypedRegion)new TypedRegion(this.beginOffset, this.length, MELDocumentPartitioner.MEL_CONTENT_TYPE));
                        computedRegions.add((ITypedRegion)new TypedRegion(MELDocumentPartitioner.this.pos, 1, MELDocumentPartitioner.EXPRESSION_BRACKETS_CONTENT_TYPE));
                        return new DefaultRegionState();
                    }
                    --this.bracketLevel;
                    ++this.length;
                    break;
                }
                default: {
                    ++this.length;
                    if (!MELDocumentPartitioner.this.isLastPosition(MELDocumentPartitioner.this.pos, text)) break;
                    computedRegions.add((ITypedRegion)new TypedRegion(this.beginOffset, this.length, MELDocumentPartitioner.MEL_CONTENT_TYPE));
                }
            }
            return this;
        }
    }

    private static interface PartitionerState {
        public PartitionerState processChar(String var1, List<ITypedRegion> var2);
    }
}

