/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.mel.partitioner;

import java.util.List;
import java.util.Optional;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtension;

public class EvaluatorExtensions {
    protected final List<EvaluatorExtension> extensions;

    public EvaluatorExtensions(List<EvaluatorExtension> extensions) {
        this.extensions = extensions;
    }

    public Optional<EvaluatorExtension> findExtensionForEvaluator(String evaluatorName) {
        return this.extensions.stream().filter(extension -> evaluatorName.equals(extension.getName())).findFirst();
    }

    protected Optional<EvaluatorExtension> findExtensionForEvaluatorAt(IDocument document, int offset) throws BadLocationException {
        int i = 0;
        while (i < offset) {
            ITypedRegion partition = document.getDocumentPartitioner().getPartition(offset - i);
            if ("org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.EVALUATOR_DECLARATION_CONTENT_TYPE".equals(partition.getType())) {
                String evaluatorName = document.get(partition.getOffset(), partition.getLength());
                return this.findExtensionForEvaluator(evaluatorName);
            }
            ++i;
        }
        return Optional.empty();
    }

    public Optional<EvaluatorExtension> findExtensionForEvaluatorAt(ITextViewer viewer, int offset) throws BadLocationException {
        return this.findExtensionForEvaluatorAt(viewer.getDocument(), offset);
    }
}

