/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.mel.partitioner;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.mel.partitioner.EvaluatorDamagerRepairer;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtension;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensions;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.IObjectRef;

public class EvaluatorExtensionManager {
    private static final EvaluatorExtensionManager INSTANCE = new EvaluatorExtensionManager();
    protected List<EvaluatorExtension> extensions;

    public static EvaluatorExtensionManager getInstance() {
        return INSTANCE;
    }

    public EvaluatorExtensions getEvaluators() {
        return new EvaluatorExtensions(this.getEvaluatorExtensions().stream().filter(e -> !e.isDefaultExpressionLanguage()).collect(Collectors.toList()));
    }

    public EvaluatorExtension getDefaultExpressionLanguageEvaluator() {
        Optional<EvaluatorExtension> findFirst = this.getEvaluatorExtensions().stream().filter(EvaluatorExtension::isDefaultExpressionLanguage).findFirst();
        return findFirst.orElseThrow(() -> new IllegalArgumentException("there is no default expression language defined"));
    }

    private List<EvaluatorExtension> getEvaluatorExtensions() {
        if (this.extensions == null) {
            List<EvaluatorExtension> extensionsList = CoreUtils.getExtensionPointObjects("org.mule.tooling.core.evaluator", EvaluatorExtension.class);
            this.extensions = extensionsList;
        }
        return this.extensions;
    }

    public IContentAssistProcessor getCompletionProcessor(final IObjectRef<EvaluatorExtensionConfiguration> configuration) {
        return new IContentAssistProcessor(){
            private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
            private final char[] PROPOSAL_ACTIVATION_CHARS = new char[]{'.', ','};
            private final ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];

            public String getErrorMessage() {
                return "no autocomplete information";
            }

            public IContextInformationValidator getContextInformationValidator() {
                return null;
            }

            public char[] getContextInformationAutoActivationCharacters() {
                return null;
            }

            public char[] getCompletionProposalAutoActivationCharacters() {
                return this.PROPOSAL_ACTIVATION_CHARS;
            }

            public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
                return this.NO_CONTEXTS;
            }

            public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
                try {
                    return EvaluatorExtensionManager.this.getEvaluators().findExtensionForEvaluatorAt(viewer, offset).map(extension -> extension.getContentAssistProcessor(configuration)).map(completionProcessor -> completionProcessor.computeCompletionProposals(viewer, offset)).orElse(this.NO_COMPLETIONS);
                }
                catch (BadLocationException e) {
                    MuleCorePlugin.logError("Error while getting content assistance for evaluator", e);
                    return this.NO_COMPLETIONS;
                }
            }
        };
    }

    public Optional<EvaluatorExtension> findExtensionFor(IDocument document, ITypedRegion region) throws BadLocationException {
        return this.getEvaluators().findExtensionForEvaluatorAt(document, region.getOffset());
    }

    public EvaluatorDamagerRepairer getDamagerRepairer() {
        return new EvaluatorDamagerRepairer(this.getEvaluators());
    }
}

