/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.mel.partitioner;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtension;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensions;

public class EvaluatorDamagerRepairer
implements IPresentationDamager,
IPresentationRepairer {
    private final EvaluatorExtensions evaluatorExtensions;
    private IDocument document;

    public EvaluatorDamagerRepairer(EvaluatorExtensions evaluatorExtensions) {
        this.evaluatorExtensions = evaluatorExtensions;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
        try {
            this.evaluatorExtensions.findExtensionForEvaluatorAt(this.document, damage.getOffset()).map(EvaluatorExtension::getDamagerRepairer).ifPresent(repairer -> {
                repairer.setDocument(this.document);
                repairer.createPresentation(presentation, damage);
            });
        }
        catch (BadLocationException e) {
            MuleCorePlugin.logError("Could not create presentation for evaluator", e);
        }
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent event, boolean documentPartitioningChanged) {
        try {
            return this.evaluatorExtensions.findExtensionForEvaluatorAt(this.document, partition.getOffset()).map(EvaluatorExtension::getDamagerRepairer).map(damager -> damager.getDamageRegion(partition, event, documentPartitioningChanged)).orElseThrow(() -> new IllegalArgumentException("could not find evaluator for region"));
        }
        catch (BadLocationException e) {
            MuleCorePlugin.logError("Could not get damage region for evaluator", e);
            return null;
        }
    }
}

