/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.tooling.core.m2.InstallationException;
import org.mule.tooling.core.m2.MavenConfiguration;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.m2.internal.Booter;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.project.MuleExtension;

public class MavenUtils {
    public static final String FILE_EXTENSION_COMMON_GAV = "org.mule.modules:mule-module-file-extension-common";
    public static final String APIKIT_ODATA_EXTENSION_GAV = "org.mule.modules:mule-module-apikit-odata";
    public static final List<String> EXTENSIONS_WITH_NO_MODEL = Arrays.asList("org.mule.modules:mule-module-file-extension-common", "org.mule.modules:mule-module-apikit-odata");
    private static final String MODEL_VERSION = "4.0.0";
    private static final String GENERIC_POM_DESCRIPTION = "POM was created from AnypointStudio";
    private static final String ERROR_LOADING_POM_XML_MESSAGE = "Unexpected error loading pom.xml";
    private static final String XML_EXTENSION = ".xml";
    public static final String GAV_SEPARATOR = ":";

    public static boolean isMulePlugin(MavenDependency dependency2) {
        return dependency2.getClassifier().map("mule-plugin"::equals).orElse(false);
    }

    public static boolean isApiSpec(MavenDependency dependency2) {
        return dependency2.getClassifier().map(CoreUtils::isAPIClassifier).orElse(false);
    }

    public static boolean isAsyncApiSpec(MavenDependency dependency2) {
        return dependency2.getClassifier().map(CoreUtils::isAsyncAPIClassifier).orElse(false);
    }

    public static String getGavString(MavenDependency dependency2) {
        String scope;
        String type;
        StringBuilder stringBuilder = new StringBuilder();
        String groupId = dependency2.getGroupId();
        stringBuilder.append(MavenUtils.get(groupId));
        stringBuilder.append(GAV_SEPARATOR);
        String artifactId = dependency2.getArtifactId();
        stringBuilder.append(MavenUtils.get(artifactId));
        String version = dependency2.getVersion();
        stringBuilder.append(GAV_SEPARATOR);
        stringBuilder.append(MavenUtils.get(version));
        String classifier = dependency2.getClassifier().orElse(null);
        if (StringUtils.isNotBlank((String)classifier)) {
            stringBuilder.append(GAV_SEPARATOR);
            stringBuilder.append(MavenUtils.get(classifier));
        }
        if (StringUtils.isNotBlank((String)(type = (String)dependency2.getType().orElse(null)))) {
            stringBuilder.append(GAV_SEPARATOR);
            stringBuilder.append(MavenUtils.get(classifier));
        }
        String string = scope = dependency2.getScope() != null ? dependency2.getScope().asString() : "";
        if (StringUtils.isNotBlank((String)scope) && !dependency2.getScope().equals((Object)MavenDependency.Scope.COMPILE)) {
            stringBuilder.append(GAV_SEPARATOR);
            stringBuilder.append(MavenUtils.get(scope));
        }
        return stringBuilder.toString();
    }

    private static String get(String coordinate) {
        return coordinate != null ? coordinate : "unspecified";
    }

    public static String getClassifier(String fileName, String artifactId, String version, String extension) {
        int endIndex;
        int beginIndex = artifactId.length() + version.length() + 2;
        return beginIndex < (endIndex = fileName.length() - extension.length() - 1) ? fileName.substring(beginIndex, endIndex) : "";
    }

    public static InstallResult installFileToLocalRepository(File artifactFile, Optional<File> pomFile, MavenDependency artifact) throws InstallationException {
        RepositorySystem system = Booter.newRepositorySystem();
        DefaultRepositorySystemSession session = Booter.newRepositorySystemSession(system, MavenCore.getM2repoPath(), Booter.RepositoryType.ENHANCED, Booter.UpdatePolicy.NEVER, true);
        InstallRequest installRequest = new InstallRequest();
        DefaultArtifact artifactToInstall = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier().orElse(""), artifact.getType().orElse("jar"), artifact.getVersion(), Collections.emptyMap(), artifactFile);
        installRequest.addArtifact((Artifact)artifactToInstall);
        MavenUtils.addPomToInstallRequest(artifactFile, pomFile, artifact, installRequest, artifactToInstall);
        try {
            InstallResult installResult = system.install((RepositorySystemSession)session, installRequest);
            return installResult;
        }
        catch (org.eclipse.aether.installation.InstallationException e) {
            throw new InstallationException(e.getMessage(), e);
        }
        finally {
            system.shutdown();
        }
    }

    public static InstallResult installPomToLocalRepository(File artifactFile, MavenDependency artifact) throws InstallationException {
        RepositorySystem system = Booter.newRepositorySystem();
        DefaultRepositorySystemSession session = Booter.newRepositorySystemSession(system, MavenCore.getM2repoPath(), Booter.RepositoryType.ENHANCED, Booter.UpdatePolicy.NEVER, true);
        InstallRequest installRequest = new InstallRequest();
        DefaultArtifact artifactToInstall = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier().orElse(""), "pom", artifact.getVersion(), Collections.emptyMap(), artifactFile);
        installRequest.addArtifact((Artifact)artifactToInstall);
        try {
            InstallResult installResult = system.install((RepositorySystemSession)session, installRequest);
            return installResult;
        }
        catch (org.eclipse.aether.installation.InstallationException e) {
            throw new InstallationException(e.getMessage(), e);
        }
        finally {
            system.shutdown();
        }
    }

    private static void addPomToInstallRequest(File artifactFile, Optional<File> pomFile, MavenDependency artifact, InstallRequest installRequest, DefaultArtifact artifactToInstall) throws InstallationException {
        Optional<File> pomToIsntall = MavenUtils.getOrCreatePomToInstall(artifactFile, pomFile, artifact);
        if (!pomToIsntall.isPresent()) {
            throw new InstallationException("Coudn't generate pom.xml for file [" + artifactFile.getAbsolutePath() + "]");
        }
        MavenUtils.addPomFileToInstallRequest(installRequest, artifactToInstall, pomToIsntall.get());
    }

    private static Optional<File> getOrCreatePomToInstall(File artifactFile, Optional<File> pomFile, MavenDependency artifact) throws InstallationException {
        Optional<File> pomToIsntall;
        if (pomFile.isPresent()) {
            pomToIsntall = pomFile;
        } else if (MavenUtils.isJarFile(artifactFile)) {
            Optional<File> pomInsideJar = MavenUtils.createTempPomFileFromJar(artifactFile);
            if (pomInsideJar.isPresent()) {
                pomToIsntall = pomInsideJar;
            } else {
                File generatedPom = MavenUtils.generatePomFor(artifact);
                pomToIsntall = Optional.of(generatedPom);
            }
        } else {
            File generatedPom = MavenUtils.generatePomFor(artifact);
            pomToIsntall = Optional.of(generatedPom);
        }
        return pomToIsntall;
    }

    private static void addPomFileToInstallRequest(InstallRequest installRequest, DefaultArtifact artifactToInstall, File pomModelFor) {
        SubArtifact pomArtifact = new SubArtifact((Artifact)artifactToInstall, "", "pom", pomModelFor);
        installRequest.addArtifact((Artifact)pomArtifact);
    }

    private static File generatePomFor(MavenDependency artifact) throws InstallationException {
        File pomModelFor;
        try {
            pomModelFor = MavenUtils.getPomModelFor(artifact);
        }
        catch (IOException e) {
            throw new InstallationException("Error while generating pom file for none Jar file.", e);
        }
        return pomModelFor;
    }

    private static boolean isJarFile(File file) {
        return "jar".equals(FilenameUtils.getExtension((String)file.getName()));
    }

    /*
     * Exception decompiling
     */
    private static Optional<File> createTempPomFileFromJar(File jarFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File getPomModelFor(MavenDependency dependency2) throws IOException {
        Model model = new Model();
        model.setArtifactId(dependency2.getArtifactId());
        model.setGroupId(dependency2.getGroupId());
        model.setVersion(dependency2.getVersion());
        model.setPackaging(dependency2.getType().orElse("jar"));
        model.setDescription(GENERIC_POM_DESCRIPTION);
        model.setModelVersion(MODEL_VERSION);
        MavenXpp3Writer writter = new MavenXpp3Writer();
        File tempFile = File.createTempFile("pom", XML_EXTENSION);
        FileWriter fWriter = new FileWriter(tempFile);
        writter.write((Writer)fWriter, model);
        return tempFile;
    }

    public static String getGA(MavenCoordinates dependency2) {
        return dependency2.getGroupId() + GAV_SEPARATOR + dependency2.getArtifactId();
    }

    public static String getGA(MavenDependency dependency2) {
        return MavenUtils.getGA((MavenCoordinates)dependency2);
    }

    public static String getGAT(MavenCoordinates dependency2) {
        String type = "jar";
        if (dependency2.getType().isPresent()) {
            type = dependency2.getType().get();
        }
        return MavenUtils.getGA(dependency2) + GAV_SEPARATOR + type;
    }

    public static String getGAT(MavenDependency dependency2) {
        return MavenUtils.getGAT((MavenCoordinates)dependency2);
    }

    public static String getGAV(MavenCoordinates dependency2) {
        return MavenUtils.getGA(dependency2) + GAV_SEPARATOR + dependency2.getVersion();
    }

    public static String getGAV(MavenDependency dependency2) {
        return MavenUtils.getGAV((MavenCoordinates)dependency2);
    }

    public static String getGAVCT(MavenDependency dependency2) {
        return MavenUtils.getGAVCT((MavenCoordinates)dependency2);
    }

    private static String getGAVCT(MavenCoordinates dependency2) {
        return MavenUtils.getGA(dependency2) + GAV_SEPARATOR + dependency2.getVersion() + GAV_SEPARATOR + dependency2.getClassifier().orElse("") + GAV_SEPARATOR + dependency2.getType().orElse("");
    }

    public static MavenDependency getPluginDependency(String gav) {
        return MavenUtils.getDependency(new MuleExtension(gav, gav));
    }

    public static MavenDependency getDependency(MuleExtension muleExtension) {
        String[] coordinates = muleExtension.getQualifier().split(GAV_SEPARATOR);
        return MavenUtils.createMulePluginDependency(coordinates[0], coordinates[1], coordinates[2], muleExtension.getScope());
    }

    public static MavenDependency createMulePluginDependency(String groupId, String artifactId, String version) {
        return MavenUtils.createMulePluginDependency(groupId, artifactId, version, MavenDependency.Scope.COMPILE.asString());
    }

    private static MavenDependency createMulePluginDependency(String groupId, String artifactId, String version, String scope) {
        return ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(groupId)).withArtifactId(artifactId)).withVersion(version)).withClassifier("mule-plugin")).withType("jar")).withScope(MavenDependency.Scope.value(scope))).build();
    }

    public static MavenDependency getDependencyFromPath(File file) {
        return MavenUtils.getDependencyFromPath(file, false);
    }

    public static MavenDependency getDependencyFromPath(File file, boolean mustBeRepositoryBased) {
        File localRepo = new File(MavenConfiguration.instance().getLocalRepositoryPath());
        return MavenUtils.getDependencyFromPathFromRepository(file, localRepo, mustBeRepositoryBased);
    }

    private static MavenDependency getDependencyFromPathFromRepository(File file, File localRepo, boolean mustBeRepositoryBased) {
        IPath repositoryPath;
        IPath filePath = Path.fromOSString((String)file.getParentFile().getAbsolutePath());
        IPath relativePath = filePath.makeRelativeTo(repositoryPath = Path.fromOSString((String)localRepo.getAbsolutePath()));
        if (relativePath.isEmpty()) {
            return null;
        }
        String[] entrySegments = relativePath.segments();
        if (mustBeRepositoryBased && ("..".equals(entrySegments[0]) || relativePath.equals((Object)filePath))) {
            return null;
        }
        if (entrySegments.length == 0) {
            return null;
        }
        String groupId = MavenUtils.getGroupId(entrySegments);
        String artifactId = MavenUtils.getArtifactId(entrySegments);
        String fileName = file.getName();
        String extension = FilenameUtils.getExtension((String)fileName);
        String version = MavenUtils.getVersion(entrySegments);
        String classifier = MavenUtils.getClassifier(fileName, artifactId, version, extension);
        return ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(groupId)).withArtifactId(artifactId)).withVersion(version)).withClassifier(classifier)).withType(extension)).withOptional(false)).build();
    }

    private static String getVersion(String[] entrySegments) {
        return entrySegments[entrySegments.length - 1];
    }

    private static String getArtifactId(String[] entrySegments) {
        return entrySegments[entrySegments.length - 2];
    }

    private static String getGroupId(String[] entrySegments) {
        StringBuilder groupIdBuilder = new StringBuilder(entrySegments[0]);
        int i = 1;
        while (i < entrySegments.length - 2) {
            groupIdBuilder.append(".").append(entrySegments[i]);
            ++i;
        }
        return groupIdBuilder.toString();
    }

    public static boolean equalsGav(MavenCoordinates dependency1, MavenCoordinates dependency2) {
        return dependency1.getGroupId().equals(dependency2.getGroupId()) && dependency1.getArtifactId().equals(dependency2.getArtifactId()) && dependency1.getVersion().equals(dependency2.getVersion());
    }

    public static BundleDescriptor getBundleDescriptor(MavenCoordinates mavenDependency) {
        BundleDescriptor.Builder builder = new BundleDescriptor.Builder().setGroupId(mavenDependency.getGroupId()).setArtifactId(mavenDependency.getArtifactId()).setVersion(mavenDependency.getVersion());
        mavenDependency.getClassifier().ifPresent(arg_0 -> ((BundleDescriptor.Builder)builder).setClassifier(arg_0));
        mavenDependency.getType().ifPresent(arg_0 -> ((BundleDescriptor.Builder)builder).setType(arg_0));
        return builder.build();
    }

    public static List<Throwable> getCausalChain(Throwable throwable) {
        Throwable cause;
        ArrayList<Throwable> causes = new ArrayList<Throwable>(4);
        causes.add(throwable);
        Throwable slowPointer = throwable;
        boolean advanceSlowPointer = false;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
            causes.add(throwable);
            if (throwable == slowPointer) {
                throw new IllegalArgumentException("Loop in causal chain detected.", throwable);
            }
            if (advanceSlowPointer) {
                slowPointer = slowPointer.getCause();
            }
            boolean bl = advanceSlowPointer = !advanceSlowPointer;
        }
        return Collections.unmodifiableList(causes);
    }

    public static Optional<MavenDependency> findProjectDeclaredExtension(IMuleProject muleProject, String groupId, String artifactId) {
        return muleProject.getDeclaredExtensions().stream().map(MavenUtils::getDependency).filter(dependency2 -> dependency2.getGroupId().equals(groupId) && dependency2.getArtifactId().equals(artifactId)).findAny();
    }
}

