/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.repo;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.repo.ZipComparator;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.exchange.ExchangeAssetUtils;

public class RepositoryComparator {
    private static final String FAILED_TO_COMPARE_LOCAL_AND_TEMPORAL_REPOSITORIES = "Failed to compare local and temporal repositories";
    private static final PathMatcher ZIP_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/*.zip");
    private static final PathMatcher JAR_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/*.jar");

    public static RepositoryComparationResult compare(ExchangeAsset exchangeAsset, File localRepo, File tempRepo) {
        RepositoryComparationResult result;
        try {
            Set<FileMismatch> diff = RepositoryComparator.getDiff(ExchangeAssetUtils.isApi(exchangeAsset) ? ZIP_MATCHER : JAR_MATCHER, tempRepo.toPath(), localRepo.toPath());
            result = diff.isEmpty() ? RepositoryComparationResult.withCoincidence() : RepositoryComparationResult.withDiff(diff);
        }
        catch (IOException e) {
            MuleCorePlugin.logError(FAILED_TO_COMPARE_LOCAL_AND_TEMPORAL_REPOSITORIES, e);
            result = RepositoryComparationResult.failed();
        }
        return result;
    }

    private static Set<FileMismatch> getDiff(final PathMatcher pathMatcher, final Path temp, final Path local) throws IOException {
        final HashSet diff = Sets.newHashSet();
        Files.walkFileTree(temp, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path visitedTemp, BasicFileAttributes attrs) throws IOException {
                FileVisitResult result = super.visitFile(visitedTemp, attrs);
                Path relativize = temp.relativize(visitedTemp);
                Path fileInOther = local.resolve(relativize);
                if (pathMatcher.matches(visitedTemp) && fileInOther.toFile().exists() && !RepositoryComparator.sameContent(visitedTemp, fileInOther)) {
                    diff.add(new FileMismatch(visitedTemp, fileInOther));
                }
                return result;
            }
        });
        return diff;
    }

    private static boolean sameContent(Path file1, Path file2) throws IOException {
        long size = Files.size(file1);
        if (size != Files.size(file2)) {
            return false;
        }
        return ZipComparator.compare(file1, file2);
    }

    public static class FileMismatch {
        private Path temp;
        private Path local;

        public FileMismatch(Path temp, Path local) {
            this.temp = temp;
            this.local = local;
        }

        public Path getLocal() {
            return this.local;
        }

        public Path getTemp() {
            return this.temp;
        }
    }

    public static class RepositoryComparationResult {
        private Status status = Status.COINCIDENCE;
        private Set<FileMismatch> fileMismatchs;

        private RepositoryComparationResult() {
        }

        public static RepositoryComparationResult withDiff(Set<FileMismatch> diffFiles) {
            RepositoryComparationResult result = new RepositoryComparationResult();
            result.fileMismatchs = diffFiles;
            result.status = Status.DIFF;
            return result;
        }

        public static RepositoryComparationResult withCoincidence() {
            return new RepositoryComparationResult();
        }

        public static RepositoryComparationResult failed() {
            RepositoryComparationResult result = new RepositoryComparationResult();
            result.status = Status.FAILED;
            return result;
        }

        public boolean hasDiff() {
            return this.status == Status.DIFF;
        }

        public Set<FileMismatch> getFileMismatchs() {
            return this.fileMismatchs;
        }

        static enum Status {
            COINCIDENCE,
            DIFF,
            FAILED;

        }
    }
}

