/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.settings;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.internal.settings.MavenSettingsHelper;
import org.mule.tooling.core.m2.internal.settings.MavenSettingsProxy;
import org.mule.tooling.core.m2.internal.settings.ProxyConfigData;
import org.mule.tooling.core.m2.internal.settings.SettingsFileTransformer;
import org.mule.tooling.core.net.ProxyData;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public class ProxySettingsFileTransformer
implements SettingsFileTransformer<ProxyConfigData> {
    public static final String PROXY_ID_PREFIX = "studio-generated-proxy-";
    public static final String NON_PROXY_HOSTS_SEPARATOR = "|";
    private final ProxyConfigData configuration;
    private static String lastMasterPassword = "";
    private static String lastProxyPassword = "";

    public ProxySettingsFileTransformer(ProxyConfigData configuration) {
        this.configuration = configuration;
    }

    public ProxySettingsFileTransformer() {
        this(new ProxyConfigData());
    }

    private List<ProxyData> getAllProxyData() {
        return this.configuration.getProxyManager().getAllProxyData();
    }

    @Override
    public boolean shouldTransform(MavenSettingsHelper mavenSettingsHelper) {
        return !this.getAllProxyData().isEmpty();
    }

    @Override
    public MavenSettingsHelper transform(MavenSettingsHelper settingsHelper) {
        int i = 1;
        for (ProxyData proxy : this.getAllProxyData()) {
            MavenSettingsProxy settingsProxy = this.createSettingsProxy(proxy, i++);
            settingsHelper.addProxy(settingsProxy);
        }
        return settingsHelper;
    }

    private MavenSettingsProxy createSettingsProxy(ProxyData proxy, int proxyIndex) {
        MavenSettingsProxy.Builder proxyBuilder = MavenSettingsProxy.builder();
        proxyBuilder.withProxyId(PROXY_ID_PREFIX + proxyIndex).withProtocol(proxy.getProtocol().toString()).withHost(proxy.getHost()).withPort(String.valueOf(proxy.getPort()));
        proxy.getAuthentication().ifPresent(authentication -> {
            Optional<File> securitySettingsFile = MavenCore.getMavenSettingsSecurity();
            String mvnSecuritySettings = securitySettingsFile.isPresent() ? securitySettingsFile.get().getAbsolutePath() : null;
            String user = authentication.getUser() != null ? authentication.getUser() : "";
            String password = authentication.getPassword() != null ? authentication.getPassword() : "";
            try {
                if (mvnSecuritySettings != null && !password.isEmpty()) {
                    DefaultPlexusCipher cipher = new DefaultPlexusCipher();
                    String masterPassword = null;
                    SettingsSecurity sec = SecUtil.read((String)mvnSecuritySettings, (boolean)true);
                    if (sec != null) {
                        masterPassword = sec.getMaster();
                    }
                    if (masterPassword != null) {
                        if (!lastMasterPassword.equals(masterPassword)) {
                            lastMasterPassword = masterPassword;
                            masterPassword = cipher.decryptDecorated(masterPassword, "settings.security");
                            lastProxyPassword = cipher.encryptAndDecorate(password, masterPassword);
                        }
                        proxyBuilder.withUsername(user);
                        proxyBuilder.withPassword(lastProxyPassword);
                    } else {
                        lastMasterPassword = "";
                        MuleCorePlugin.logError("Master password is not set in the setting security file: " + mvnSecuritySettings);
                    }
                } else {
                    MuleCorePlugin.logWarning("Maven security settings file could not be found, passwords will be used by maven unencrypted.");
                    proxyBuilder.withUsername(user);
                    proxyBuilder.withPassword(password);
                }
            }
            catch (PlexusCipherException | SecDispatcherException e) {
                MuleCorePlugin.logError("There was an error encrypting proxy authentication settings.", e);
            }
        });
        if (!proxy.getNonProxiedHosts().isEmpty()) {
            proxyBuilder.withNonProxyHosts(proxy.getNonProxiedHosts().stream().collect(Collectors.joining(NON_PROXY_HOSTS_SEPARATOR)));
        }
        return proxyBuilder.build();
    }

    @Override
    public ProxyConfigData getLatestConfigData() {
        return new ProxyConfigData();
    }

    @Override
    public ProxyConfigData getConfigData() {
        return this.configuration;
    }
}

