/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.settings;

import org.apache.maven.settings.Proxy;

public class MavenSettingsProxy {
    private final String proxyId;
    private final String protocol;
    private final String host;
    private final String port;
    private final String nonProxyHosts;
    private final String username;
    private final String password;

    public MavenSettingsProxy(String proxyId, String protocol, String host, String port, String nonProxyHosts, String username, String password) {
        this.proxyId = proxyId;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.nonProxyHosts = nonProxyHosts;
        this.username = username;
        this.password = password;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MavenSettingsProxy fromProxy(Proxy proxy) {
        String proxyId = proxy.getId();
        String protocol = proxy.getProtocol();
        String host = proxy.getHost();
        String port = String.valueOf(proxy.getPort());
        String nonProxyHosts = proxy.getNonProxyHosts() != null ? proxy.getNonProxyHosts() : "";
        String username = proxy.getUsername() != null ? proxy.getUsername() : "";
        String password = proxy.getPassword() != null ? proxy.getPassword() : "";
        return new MavenSettingsProxy(proxyId, protocol, host, port, nonProxyHosts, username, password);
    }

    public String getProxyId() {
        return this.proxyId;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public static class Builder {
        private String proxyId;
        private String protocol;
        private String host;
        private String port;
        private String nonProxyHosts = "";
        private String username = "";
        private String password = "";

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withPort(String port) {
            this.port = port;
            return this;
        }

        public Builder withProxyId(String proxyId) {
            this.proxyId = proxyId;
            return this;
        }

        public Builder withProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder withNonProxyHosts(String nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts;
            return this;
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public MavenSettingsProxy build() {
            return new MavenSettingsProxy(this.proxyId, this.protocol, this.host, this.port, this.nonProxyHosts, this.username, this.password);
        }
    }
}

