/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.settings;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.mule.tooling.core.m2.XmlEditingHelper;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.internal.settings.MavenSettingsProxy;
import org.mule.tooling.core.utils.StudioFileUtils;
import org.mule.tooling.core.xml.XmlFactoryUtils;
import org.mule.tooling.core.xml.format.XmlFormatter;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MavenSettingsHelper {
    private static final String SERVER_BY_ID_XPATH = "settings/servers/server/id[text()='%s']";
    private static final String SERVER_USERNAME = "settings/servers/server/id[text()='%s']/following-sibling::username";
    private static final String SERVER_PASSWORD = "settings/servers/server/id[text()='%s']/following-sibling::password";
    private static final String ID_PARENT = "settings/servers/server/id[text()='%s']/parent::server";
    private Settings settings;
    private Document document;
    private File srcFile;

    public static MavenSettingsHelper create(File srcFile) throws SAXException, IOException {
        return new MavenSettingsHelper(srcFile);
    }

    public MavenSettingsHelper(File srcFile) throws SAXException, IOException {
        this.settings = MavenCore.getSettings(srcFile);
        this.srcFile = srcFile;
        this.readDocument(srcFile);
    }

    public boolean hasServer(String serverId) {
        return this.settings.getServers().stream().anyMatch(server -> server.getId().equals(serverId));
    }

    public List<Server> getServers() {
        return this.settings.getServers();
    }

    public Server getServer(String serverId) {
        return this.settings.getServers().stream().filter(server -> server.getId().equals(serverId)).findFirst().orElseThrow(() -> new IllegalArgumentException("invalid server id " + serverId));
    }

    public void addServer(String id, String username, String password) {
        new XmlEditingHelper(this.document).getOrCreateElement("settings").getOrCreateElement("servers").createElement("server").createElement("id").setValue(id).createElement("username").setValue(username).createElement("password").setValue(password);
    }

    public void editServer(String id, Server server) {
        try {
            XmlEditingHelper xmlEditingHelper = new XmlEditingHelper(this.document);
            this.setXmlNodeTextValue(xmlEditingHelper, String.format(SERVER_USERNAME, id), server.getUsername());
            this.setXmlNodeTextValue(xmlEditingHelper, String.format(SERVER_PASSWORD, id), server.getPassword());
            this.setXmlNodeTextValue(xmlEditingHelper, String.format(SERVER_BY_ID_XPATH, id), server.getId());
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
    }

    private void setXmlNodeTextValue(XmlEditingHelper xmlEditingHelper, String xPath, String value) throws XPathExpressionException {
        XmlEditingHelper xmlNode = xmlEditingHelper.findChild(xPath);
        if (xmlNode != null) {
            xmlNode.setValue(value);
        }
    }

    public void removeServer(String id) {
        try {
            XmlEditingHelper serverNode = new XmlEditingHelper(this.document).findChild(String.format(ID_PARENT, id));
            if (serverNode != null) {
                serverNode.remove();
            }
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
    }

    private void readDocument(File file) throws SAXException, IOException {
        DocumentBuilder dBuilder = XmlFactoryUtils.createSecureDocumentBuilder();
        this.document = dBuilder.parse(file);
    }

    public void write(File outputFile) throws IOException {
        XmlFormatter.removeWhitespaceNodes(this.document);
        DOMSource source = new DOMSource(this.document);
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (FileOutputStream pomOutputStream = new FileOutputStream(outputFile);){
                OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)pomOutputStream, StandardCharsets.UTF_8);
                StreamResult result = new StreamResult(outputWriter);
                TransformerFactory transformerFactory = XmlFactoryUtils.createSecureTransformerFactory();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("doctype-public", "");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(XmlFormatter.getIndentationSize()));
                transformer.transform(source, result);
                XmlFormatter.postProcess(outputFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public void addProxy(MavenSettingsProxy proxy) {
        XmlEditingHelper proxyHelper = new XmlEditingHelper(this.document).getOrCreateElement("settings").getOrCreateElement("proxies").createElement("proxy");
        proxyHelper.createElement("active").setValue("true").createElement("id").setValue(proxy.getProxyId()).createElement("protocol").setValue(proxy.getProtocol()).createElement("host").setValue(proxy.getHost()).createElement("port").setValue(proxy.getPort());
        if (!proxy.getNonProxyHosts().isEmpty()) {
            proxyHelper.createElement("nonProxyHosts").setValue(proxy.getNonProxyHosts());
        }
        if (!proxy.getUsername().isEmpty()) {
            proxyHelper.createElement("username").setValue(proxy.getUsername());
        }
        if (!proxy.getPassword().isEmpty()) {
            proxyHelper.createElement("password").setValue(proxy.getPassword());
        }
    }

    public boolean hasProxy(String proxyId) {
        List proxies = this.settings.getProxies();
        boolean found = false;
        for (Proxy proxy : proxies) {
            if (!proxyId.equals(proxy.getId())) continue;
            found = true;
            break;
        }
        return found;
    }

    public MavenSettingsProxy getProxy(String proxyId) {
        List proxies = this.settings.getProxies();
        Proxy targetProxy = null;
        for (Proxy proxy : proxies) {
            if (!proxyId.equals(proxy.getId())) continue;
            targetProxy = proxy;
            break;
        }
        return MavenSettingsProxy.fromProxy(targetProxy);
    }

    public File getSourceFile() {
        return this.srcFile;
    }

    public static File createTempFile() {
        return StudioFileUtils.getTempFileAt("settings-temp-directory", UUID.randomUUID().toString() + ".xml");
    }

    public boolean hasSameSettings(MavenSettingsHelper otherHelper) {
        if (otherHelper != null) {
            return this.document.isEqualNode(otherHelper.document);
        }
        return false;
    }
}

