/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.settings;

import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.m2.ExchangeMavenFacade;
import org.mule.tooling.core.m2.internal.settings.LoginConfigData;
import org.mule.tooling.core.m2.internal.settings.MavenSettingsHelper;
import org.mule.tooling.core.m2.internal.settings.SettingsFileTransformer;

public class LoginSettingsFileTransformer
implements SettingsFileTransformer<LoginConfigData> {
    private static final String TOKEN_USER_ID = "~~~Token~~~";
    private LoginConfigData configuration;

    public LoginSettingsFileTransformer(LoginConfigData configuration) {
        this.configuration = configuration;
    }

    public LoginSettingsFileTransformer() {
        this(new LoginConfigData());
    }

    @Override
    public boolean shouldTransform(MavenSettingsHelper mavenSettingsHelper) {
        return this.configuration != null && this.configuration.getActiveAuthUser() != null;
    }

    @Override
    public MavenSettingsHelper transform(MavenSettingsHelper mavenSettingsHelper) {
        return this.transform(mavenSettingsHelper, this.configuration.getActiveAuthUser());
    }

    public MavenSettingsHelper transform(MavenSettingsHelper mavenSettingsHelper, AuthUser activeAuthUser) {
        ExchangeMavenFacade.getKnownRepositoryIds().stream().forEach(serverId -> this.addIfNecessary((String)serverId, mavenSettingsHelper, activeAuthUser));
        return mavenSettingsHelper;
    }

    private void addIfNecessary(String serverId, MavenSettingsHelper mavenSettingsHelper, AuthUser activeAuthUser) {
        if (!mavenSettingsHelper.hasServer(serverId)) {
            mavenSettingsHelper.addServer(serverId, TOKEN_USER_ID, activeAuthUser.getToken());
        }
    }

    @Override
    public LoginConfigData getLatestConfigData() {
        return new LoginConfigData();
    }

    @Override
    public LoginConfigData getConfigData() {
        return this.configuration;
    }
}

