/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.settings;

import org.mule.tooling.core.auth.AuthUser;
import org.mule.tooling.core.auth.IAuthResult;
import org.mule.tooling.core.m2.internal.settings.SettingsFileTransformer;
import org.mule.tooling.core.utils.CoreUtils;

public class LoginConfigData
extends SettingsFileTransformer.ConfigData {
    private AuthUser activeAuthUser;

    public LoginConfigData(AuthUser activeAuthUser) {
        this.activeAuthUser = activeAuthUser;
    }

    public LoginConfigData() {
        this(LoginConfigData.currentValidActiveUser());
    }

    public AuthUser getActiveAuthUser() {
        return this.activeAuthUser;
    }

    public static AuthUser currentValidActiveUser() {
        IAuthResult<Boolean> tokenValid;
        AuthUser activeAuthUser = CoreUtils.getLoginManager().retrieveActiveAuthUser();
        if (activeAuthUser != null && (tokenValid = CoreUtils.getLoginManager().isTokenValid(activeAuthUser, false)).succeeded() && tokenValid.getResult().booleanValue()) {
            return activeAuthUser;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.activeAuthUser == null ? 0 : this.activeAuthUser.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoginConfigData other = (LoginConfigData)obj;
        return !(this.activeAuthUser == null ? other.activeAuthUser != null : !this.activeAuthUser.equals(other.activeAuthUser));
    }
}

