/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.repo.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.internal.repo.MavenRepositoryEntry;
import org.mule.tooling.core.m2.internal.repo.MavenRepositoryPackagingStrategy;
import org.mule.tooling.core.m2.internal.repo.bundle.BundleRepositoryEntry;
import org.osgi.framework.Bundle;

public class BundleRepositoryStrategy
implements MavenRepositoryPackagingStrategy {
    private String basePath;
    private final Bundle bundle;
    private final long timestamp;
    private final Map<String, Long> fileLengths;

    public BundleRepositoryStrategy(Bundle bundle, String basePath, long timestamp) {
        this.bundle = bundle;
        this.basePath = basePath;
        this.timestamp = timestamp;
        this.fileLengths = this.initializeSize();
    }

    private Map<String, Long> initializeSize() {
        URL entry = this.bundle.getEntry(this.basePath + "artifact-sizes.properties");
        HashMap<String, Long> fileSizes = new HashMap<String, Long>();
        if (entry != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream sizesFile = entry.openStream();){
                    Properties properties = new Properties();
                    properties.load(sizesFile);
                    properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(fileEntry, size) -> fileSizes.put((String)fileEntry, Long.valueOf((String)size))));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                MuleCorePlugin.logError("Unexpected error reading properties. The application will still operate normally, but this may affect the performance. Please notify support about this.", e);
            }
        }
        return fileSizes;
    }

    @Override
    public Enumeration<URL> getEntryUrls(List<String> extensions) {
        List enumerations = extensions.stream().map(extension -> this.bundle.findEntries(this.basePath, "*" + extension, true)).filter(Objects::nonNull).collect(Collectors.toList());
        return new CompositeEnumeration<URL>(enumerations);
    }

    @Override
    public BundleRepositoryEntry createEntry(String entryPath, Set<String> fileNames) {
        return new BundleRepositoryEntry(this.timestamp, this.bundle, this.basePath, entryPath, fileNames, this);
    }

    @Override
    public List<URL> getEntries(MavenRepositoryEntry entry) {
        Enumeration entries = this.bundle.findEntries(this.basePath + entry.getEntryPath(), "*", false);
        return Collections.list(entries);
    }

    public String toString() {
        return "BundleRepositorySource [bundle=" + String.valueOf(this.bundle) + ", basePath=" + this.basePath + ", timestamp=" + this.timestamp + "]";
    }

    @Override
    public String getFileName(URL entryUrl) {
        String entryPath = entryUrl.getPath();
        return entryPath.substring(entryPath.lastIndexOf(47) + 1);
    }

    @Override
    public Long getFileLength(String entryRelativePath) {
        return this.fileLengths.computeIfAbsent(entryRelativePath, x -> 0L);
    }

    private class CompositeEnumeration<T>
    implements Enumeration<T> {
        private final List<Enumeration<T>> enumerations;
        private Enumeration<T> current;
        private int currentIndex = 0;

        public CompositeEnumeration(List<Enumeration<T>> enumerations) {
            this.enumerations = enumerations;
            this.current = enumerations.isEmpty() ? null : enumerations.get(0);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasMoreElements() {
            if (!this.enumerations.isEmpty()) ** GOTO lbl5
            return false;
lbl-1000:
            // 1 sources

            {
                ++this.currentIndex;
                this.current = this.enumerations.get(this.currentIndex);
lbl5:
                // 2 sources

                ** while (!this.current.hasMoreElements() && this.currentIndex < this.enumerations.size() - 1)
            }
lbl6:
            // 1 sources

            return this.current.hasMoreElements();
        }

        @Override
        public T nextElement() {
            return this.current.nextElement();
        }
    }
}

