/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.repo.bundle;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.mule.tooling.core.m2.internal.repo.MavenRepositoryEntry;
import org.mule.tooling.core.m2.internal.repo.MavenRepositoryPackagingStrategy;
import org.mule.tooling.core.m2.internal.repo.RemoteRepositoriesMetadata;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.utils.LazyValue;
import org.osgi.framework.Bundle;

public class BundleRepositoryEntry
implements MavenRepositoryEntry {
    protected final long timestamp;
    private final String[] entrySegments;
    private final Set<String> fileNames;
    private MavenRepositoryPackagingStrategy packagingStrategy;
    private final Bundle bundle;
    private final String basePath;
    private final String entryPath;
    private final LazyValue<Map<String, Long>> fileLengths;

    public BundleRepositoryEntry(long timestamp, Bundle bundle, String basePath, String entryPath, Set<String> fileNames, MavenRepositoryPackagingStrategy packagingStrategy) {
        this.timestamp = timestamp;
        this.entrySegments = entryPath.split("/");
        this.fileNames = fileNames;
        this.packagingStrategy = packagingStrategy;
        this.bundle = bundle;
        this.basePath = basePath;
        this.entryPath = entryPath;
        this.fileLengths = new LazyValue(this::initializeFileLengths);
    }

    @Override
    public Set<String> getFileNames() {
        return this.fileNames;
    }

    @Override
    public boolean existsIn(File destRepository) {
        boolean exists = false;
        if (BundleRepositoryEntry.getBaseFileInRepository(destRepository, this.entrySegments).exists()) {
            List<File> artifactFiles = Arrays.asList(this.getArtifactFiles(destRepository));
            Set artifactFileNames = artifactFiles.stream().map(File::getName).collect(Collectors.toSet());
            exists = this.fileNames.stream().allMatch(artifactFileNames::contains);
        }
        return exists;
    }

    @Override
    public boolean overrides(File destRepository) {
        boolean overrides = false;
        overrides = this.isLocallyInstalled(destRepository) ? (this.isSnapshot() ? this.isNewerThan(destRepository) : this.haveDifferentContents(destRepository)) : true;
        return overrides;
    }

    private boolean haveDifferentContents(File destRepository) {
        File[] artifactsInDestRepository = this.getArtifactFiles(destRepository);
        return Arrays.stream(artifactsInDestRepository).anyMatch(file -> file.length() != this.getFileLength(file.getName()));
    }

    private boolean isLocallyInstalled(File destRepository) {
        RemoteRepositoriesMetadata remoteRepositoriesMetadata = this.getRemoteRepositoryMetadata(destRepository);
        if (remoteRepositoriesMetadata.isMetadataFormatValid()) {
            Set<String> srcArtifactFilenames = this.getEntryFilenames();
            return Arrays.stream(this.getArtifactFiles(destRepository)).filter(f -> srcArtifactFilenames.contains(f.getName())).map(File::getName).allMatch(remoteRepositoriesMetadata::isLocallyInstalled);
        }
        return false;
    }

    protected Set<String> getEntryFilenames() {
        return this.fileNames;
    }

    @Override
    public RemoteRepositoriesMetadata getRemoteRepositoryMetadata(File destRepository) {
        File baseFileInRepository = BundleRepositoryEntry.getBaseFileInRepository(destRepository, this.entrySegments);
        return new RemoteRepositoriesMetadata(baseFileInRepository);
    }

    @Override
    public List<Artifact> getArtifacts(File destRepository) throws IOException {
        File baseFileInRepository = BundleRepositoryEntry.getBaseFileInRepository(destRepository, this.entrySegments);
        if (!baseFileInRepository.exists()) {
            baseFileInRepository.mkdirs();
        }
        this.doCopyInto(baseFileInRepository);
        return this.doGetArtifacts(destRepository);
    }

    protected void doCopyInto(File baseFileInRepository) throws IOException {
        List<URL> entries = this.packagingStrategy.getEntries(this);
        for (URL entryUrl : entries) {
            String fileName = entryUrl.getPath().substring(entryUrl.getPath().lastIndexOf(47) + 1);
            File outputFile = new File(baseFileInRepository, fileName);
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream stream = entryUrl.openStream();){
                Files.copy(stream, outputFile.toPath(), new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    protected List<Artifact> doGetArtifacts(File destRepository) {
        File[] artifactFiles = this.getArtifactFiles(destRepository);
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(artifactFiles.length);
        File[] fileArray = artifactFiles;
        int n = artifactFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File artifactFile = fileArray[n2];
            String artifactId = this.getArtifactId();
            String fileName = artifactFile.getName();
            String extension = FilenameUtils.getExtension((String)fileName);
            String version = this.getVersion();
            String classifier = MavenUtils.getClassifier(fileName, artifactId, version, extension);
            DefaultArtifact artifact = new DefaultArtifact(this.getGroupId(), artifactId, classifier, extension, version, null, artifactFile);
            artifacts.add((Artifact)artifact);
            ++n2;
        }
        return artifacts;
    }

    protected String getVersion() {
        return this.entrySegments[this.entrySegments.length - 1];
    }

    protected boolean isSnapshot() {
        return this.getVersion().endsWith("-SNAPSHOT");
    }

    protected String getArtifactId() {
        return this.entrySegments[this.entrySegments.length - 2];
    }

    protected String getGroupId() {
        StringBuilder groupIdBuilder = new StringBuilder(this.entrySegments[0]);
        int i = 1;
        while (i < this.entrySegments.length - 2) {
            groupIdBuilder.append(".").append(this.entrySegments[i]);
            ++i;
        }
        return groupIdBuilder.toString();
    }

    public static File getBaseFileInRepository(File destRepository, String[] segments) {
        String absolutePath = destRepository.getAbsolutePath();
        StringBuilder filePathBuilder = new StringBuilder(absolutePath.endsWith(File.separator) ? absolutePath.substring(0, absolutePath.length() - 1) : absolutePath);
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            filePathBuilder.append(File.separator);
            filePathBuilder.append(segment);
            ++n2;
        }
        String filePath = filePathBuilder.toString();
        File baseFileInRepository = new File(filePath);
        return baseFileInRepository;
    }

    protected File[] getArtifactFiles(File destRepository) {
        File baseFileInRepository = BundleRepositoryEntry.getBaseFileInRepository(destRepository, this.entrySegments);
        Set<String> entryFilenames = this.getEntryFilenames();
        File[] artifactFiles = baseFileInRepository.listFiles((_file, _name) -> entryFilenames.contains(_name));
        return artifactFiles;
    }

    protected boolean isNewerThan(File destRepository) {
        File[] artifactFiles = this.getArtifactFiles(destRepository);
        return Arrays.stream(artifactFiles).noneMatch(f -> f.lastModified() > this.timestamp);
    }

    @Override
    public String getEntryPath() {
        return this.entryPath;
    }

    private Map<String, Long> initializeFileLengths() {
        HashMap<String, Long> fileLengthsMap = new HashMap<String, Long>();
        Enumeration entries = this.bundle.findEntries(this.basePath + this.getEntryPath(), "*", false);
        while (entries.hasMoreElements()) {
            URL entryUrl = (URL)entries.nextElement();
            String entryName = entryUrl.getPath().substring(entryUrl.getPath().lastIndexOf(47) + 1);
            if (!entryName.startsWith("_fileSize_")) continue;
            int suffixIndex = entryName.lastIndexOf("_");
            String fileName = entryName.substring("_fileSize_".length(), suffixIndex);
            long fileSize = Long.parseLong(entryName.substring(suffixIndex + 1));
            fileLengthsMap.put(fileName, fileSize);
        }
        return fileLengthsMap;
    }

    public String toString() {
        return "BundleRepositoryEntry [entryPath=" + this.getEntryPath() + ", timestamp=" + this.timestamp + "]";
    }

    protected long getFileLength(String name) {
        long size = 0L;
        if (this.getEntryFilenames().contains(name)) {
            String relativePath = this.getEntryPath() + "/" + name;
            size = this.packagingStrategy.getFileLength(relativePath);
        }
        return size != 0L ? size : ((Map)this.fileLengths.getOrCompute()).computeIfAbsent(name, x -> 0L);
    }

    @Override
    public void setPackagingStrategy(MavenRepositoryPackagingStrategy packagingStrategy) {
        this.packagingStrategy = packagingStrategy;
    }
}

