/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.repo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.core.MuleCorePlugin;

public class RemoteRepositoriesMetadata {
    public static final String REMOTE_REPOSITORIES_FILENAME = "_remote.repositories";
    public static final String REMOTE_REPOSITORIES_BACKUP_FILENAME = "_remote.repositories.backup";
    public static final String LOCALLY_INSTALLED_VALUE = "";
    private static final String KEY_REGEX = "([^>]+)>(.*)";
    private static final Pattern KEY_PATTERN = Pattern.compile("([^>]+)>(.*)");
    private final File remoteRepositoriesFile;
    private boolean metadataFormatValid;
    private Optional<Map<String, Set<String>>> contents;

    public RemoteRepositoriesMetadata(File baseFolder) {
        this.remoteRepositoriesFile = new File(baseFolder, REMOTE_REPOSITORIES_FILENAME);
        this.metadataFormatValid = true;
        this.contents = this.load();
    }

    private Optional<Map<String, Set<String>>> load() {
        Optional<Map<String, Set<String>>> result = Optional.empty();
        if (this.remoteRepositoriesFile.exists()) {
            HashMap<String, Set> contentsMap = new HashMap<String, Set>();
            Properties remoteRepositoriesProperties = new Properties();
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileInputStream inStream = new FileInputStream(this.remoteRepositoriesFile);){
                    remoteRepositoriesProperties.load(inStream);
                    Set<Object> keys = remoteRepositoriesProperties.keySet();
                    for (Object key : keys) {
                        String keyString = (String)key;
                        Matcher keyMatcher = KEY_PATTERN.matcher(keyString);
                        if (keyMatcher.matches()) {
                            String artifact = keyMatcher.group(1);
                            String repositoryOrNull = keyMatcher.group(2);
                            String repository = StringUtils.isBlank((CharSequence)repositoryOrNull) ? LOCALLY_INSTALLED_VALUE : repositoryOrNull;
                            Set reposForArtifact = contentsMap.computeIfAbsent(artifact, _key -> new HashSet());
                            reposForArtifact.add(repository);
                            continue;
                        }
                        this.metadataFormatValid = false;
                        contentsMap = null;
                        break;
                    }
                    result = Optional.ofNullable(contentsMap);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                MuleCorePlugin.logWarning("There was a problem reading " + this.remoteRepositoriesFile.getAbsolutePath(), e);
            }
        }
        return result;
    }

    public boolean isMetadataFormatValid() {
        return this.metadataFormatValid;
    }

    public Set<String> getRepositoriesForArtifact(String fileName) {
        return this.contents.map(contentsMap -> (Set)contentsMap.get(fileName)).orElse(Collections.emptySet());
    }

    public boolean isLocallyInstalled(String fileName) {
        return !this.contents.isPresent() || this.getRepositoriesForArtifact(fileName).contains(LOCALLY_INSTALLED_VALUE);
    }

    public void backup() {
        File backupFile = new File(this.remoteRepositoriesFile.getParentFile(), REMOTE_REPOSITORIES_BACKUP_FILENAME);
        int i = 1;
        while (backupFile.exists()) {
            backupFile = new File(this.remoteRepositoriesFile.getParentFile(), REMOTE_REPOSITORIES_BACKUP_FILENAME + i);
            ++i;
        }
        boolean success = this.remoteRepositoriesFile.renameTo(backupFile);
        if (!success) {
            String previousContents = null;
            try {
                previousContents = FileUtils.readFileToString((File)this.remoteRepositoriesFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            MuleCorePlugin.logWarning((String)("Failed to backup " + this.remoteRepositoriesFile.getAbsolutePath() + " which has an unknown format before overwriting it." + previousContents != null ? " Previous contents:\n" + previousContents : LOCALLY_INSTALLED_VALUE));
        }
    }
}

