/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.repo;

import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.m2.internal.repo.BaseMavenRepositorySource;
import org.mule.tooling.core.m2.internal.repo.CompanionBundlePackagingStrategy;
import org.mule.tooling.core.m2.internal.repo.FileSizeMarksStrategy;
import org.mule.tooling.core.m2.internal.repo.MavenRepositoryPackagingStrategy;
import org.mule.tooling.core.m2.internal.repo.MavenRepositorySource;
import org.mule.tooling.core.m2.internal.repo.bundle.BundleRepositoryStrategy;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionChildElement;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

@ExtensionPoint(extensionPointId="org.mule.tooling.core.m2repository")
public class MavenRepositoryExtension {
    @Inject
    private Bundle bundle;
    @ExtensionAttribute(optional=false)
    private String path;
    @ExtensionAttribute(optional=false)
    private String timestampFilePath;
    @ExtensionChildElement(attributeName="id", childElementsName="companionBundle", elementType=String.class, optional=true)
    private List<String> bundleIds = Collections.emptyList();

    public static List<MavenRepositoryExtension> getExtensions() {
        return ExtensionsHolder.extensions;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTimestampFilePath() {
        return this.timestampFilePath;
    }

    public void setTimestampFilePath(String timestampFile) {
        this.timestampFilePath = timestampFile;
    }

    public MavenRepositorySource getRepositorySource() {
        MavenRepositoryPackagingStrategy packagingStrategy = new FileSizeMarksStrategy(new BundleRepositoryStrategy(this.bundle, this.normalize(this.path), this.getTimestamp()));
        if (!this.bundleIds.isEmpty()) {
            List<Bundle> bundles = this.bundleIds.stream().map(Platform::getBundle).filter(Objects::nonNull).collect(Collectors.toList());
            packagingStrategy = new CompanionBundlePackagingStrategy(bundles, packagingStrategy);
        }
        return new BaseMavenRepositorySource(this.normalize(this.path), packagingStrategy);
    }

    private String normalize(String path) {
        Object normalized = path;
        if (!((String)normalized).startsWith("/")) {
            normalized = "/" + (String)normalized;
        }
        if (!((String)normalized).endsWith("/")) {
            normalized = (String)normalized + "/";
        }
        return normalized;
    }

    public long getTimestamp() {
        Enumeration entries = this.bundle.findEntries("/", this.timestampFilePath, false);
        if (entries == null || !entries.hasMoreElements()) {
            return 0L;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream entryStream = ((URL)entries.nextElement()).openStream();){
                String timestampValue = IOUtils.toString((InputStream)entryStream);
                return Long.parseLong(timestampValue);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logError("Error reading timestamp value for Maven Repository Extension " + String.valueOf(this), e);
            return 0L;
        }
    }

    public String toString() {
        return "MavenRepositoryExtension [bundle=" + String.valueOf(this.bundle) + ", path=" + this.path + ", timestampFilePath=" + this.timestampFilePath + "]";
    }

    public void setBundleIds(List<String> bundleIds) {
        this.bundleIds = bundleIds;
    }

    public void installIntoIfRequired(File mavenRepository) throws IOException {
        boolean versionsDontMatch;
        ScopedPreferenceStore preferenceStore = MuleCorePlugin.getScopedPreferenceStore();
        String pluginMavenRepoPopulatorId = this.getStoreId();
        String storedUiPluginVersion = preferenceStore.getString(pluginMavenRepoPopulatorId);
        Version storedVersion = Version.parseVersion((String)storedUiPluginVersion);
        Version currentVersion = this.getBundle().getVersion();
        boolean bl = versionsDontMatch = currentVersion.compareTo(storedVersion) != 0;
        if (versionsDontMatch) {
            long ini = System.currentTimeMillis();
            this.getRepositorySource().installInto(mavenRepository);
            long seconds = (System.currentTimeMillis() - ini) / 1000L;
            MuleCorePlugin.debugTracer().trace("/debug/maven-repo-populate", "Copied maven repository entries in " + seconds + " secs");
            preferenceStore.setValue(pluginMavenRepoPopulatorId, currentVersion.toString());
            preferenceStore.save();
        } else {
            MuleCorePlugin.debugTracer().trace("/debug/maven-repo-populate", String.format("Maven contributions to repo from %s already installed.", this.getBundle().getSymbolicName()));
        }
    }

    public void clearInstallationInfo() throws IOException {
        ScopedPreferenceStore preferenceStore = MuleCorePlugin.getScopedPreferenceStore();
        String pluginMavenRepoPopulatorId = this.getStoreId();
        preferenceStore.setValue(pluginMavenRepoPopulatorId, Version.emptyVersion.toString());
        preferenceStore.save();
    }

    private String getStoreId() {
        String bundleSymbolicName = this.getBundle().getSymbolicName();
        String pluginMavenRepoPopulatorId = bundleSymbolicName + "_" + Events.MAVEN_REPOSITORY_POPULATED;
        return pluginMavenRepoPopulatorId;
    }

    public static void clearMavenRepositoryInstallationInfo() {
        MavenRepositoryExtension.getExtensions().forEach(x -> {
            try {
                x.clearInstallationInfo();
            }
            catch (IOException ex) {
                MuleCorePlugin.logError("Unexpected error resetting M2 repository information", ex);
            }
        });
    }

    private static class ExtensionsHolder {
        private static final List<MavenRepositoryExtension> extensions = IExtensionPointReader.create(MavenRepositoryExtension.class).readAll();

        private ExtensionsHolder() {
        }
    }
}

