/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.repo;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mule.tooling.core.m2.internal.repo.MavenRepositoryEntry;
import org.mule.tooling.core.m2.internal.repo.MavenRepositoryPackagingStrategy;
import org.osgi.framework.Bundle;

public class CompanionBundlePackagingStrategy
implements MavenRepositoryPackagingStrategy {
    public static final String PROVIDED_EXTENSION = ".txt";
    public static final String PROVIDED_PREFIX = "__PROVIDED__";
    public static final String PROVIDED_SUFFIX = "__PROVIDED__";
    private static final String PROVIDED_REGEX = "__PROVIDED__(.*?)__PROVIDED__\\.txt";
    private static final Pattern PROVIDED_PATTERN = Pattern.compile("__PROVIDED__(.*?)__PROVIDED__\\.txt");
    private List<Bundle> bundles;
    private MavenRepositoryPackagingStrategy decorated;

    public CompanionBundlePackagingStrategy(List<Bundle> bundles, MavenRepositoryPackagingStrategy decorated) {
        this.bundles = bundles;
        this.decorated = decorated;
    }

    @Override
    public List<URL> getEntries(MavenRepositoryEntry entry) {
        List<URL> entries = this.decorated.getEntries(entry);
        return entries.stream().map(entryUrl -> {
            String path = this.decorated.getFileName((URL)entryUrl);
            Matcher matcher = PROVIDED_PATTERN.matcher(path);
            if (matcher.matches()) {
                entryUrl = this.resolve(matcher.group(1), (URL)entryUrl);
            }
            return entryUrl;
        }).collect(Collectors.toList());
    }

    private URL resolve(String fileName, URL entryUrl) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream openStream = entryUrl.openStream();){
                String locationInBundle = IOUtil.toString((InputStream)openStream);
                for (Bundle bundle : this.bundles) {
                    URL[] entries = FileLocator.findEntries((Bundle)bundle, (IPath)new Path(locationInBundle));
                    if (entries.length <= 0) continue;
                    return entries[0];
                }
                throw new IllegalStateException("Provided jar: " + locationInBundle + " could not be found in any of the Companion Bundles: " + this.bundles.stream().map(Object::toString).collect(Collectors.joining(", ")));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Enumeration<URL> getEntryUrls(List<String> artifactExtensions) {
        ArrayList<String> newExtensions = new ArrayList<String>(artifactExtensions);
        newExtensions.add(PROVIDED_EXTENSION);
        return this.decorated.getEntryUrls(newExtensions);
    }

    @Override
    public MavenRepositoryEntry createEntry(String entryBasePath, Set<String> fileNames) {
        MavenRepositoryEntry entry = this.decorated.createEntry(entryBasePath, fileNames);
        entry.setPackagingStrategy(this);
        return entry;
    }

    @Override
    public String getFileName(URL entryUrl) {
        String fileName = this.decorated.getFileName(entryUrl);
        Matcher matcher = PROVIDED_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return fileName;
    }

    @Override
    public Long getFileLength(String entryRelativePath) {
        return this.decorated.getFileLength(entryRelativePath);
    }
}

