/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.repo;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.m2.internal.Booter;
import org.mule.tooling.core.m2.internal.repo.MavenRepositoryEntry;
import org.mule.tooling.core.m2.internal.repo.MavenRepositoryPackagingStrategy;
import org.mule.tooling.core.m2.internal.repo.MavenRepositorySource;
import org.mule.tooling.core.m2.internal.repo.RemoteRepositoriesMetadata;

public class BaseMavenRepositorySource
implements MavenRepositorySource {
    private MavenRepositoryPackagingStrategy packagingStrategy;
    protected final String basePath;

    public BaseMavenRepositorySource(String basePath, MavenRepositoryPackagingStrategy packagingStrategy) {
        this.basePath = basePath;
        this.packagingStrategy = packagingStrategy;
    }

    @Override
    public void installInto(File destRepository) {
        File temporalDirectory = MuleResourceUtils.createRandomTemporalDirectory();
        InstallRequest installRequest = new InstallRequest();
        try {
            try {
                Collection<MavenRepositoryEntry> entries = this.getEntries();
                for (MavenRepositoryEntry entry : entries) {
                    if (entry.existsIn(destRepository) && !entry.overrides(destRepository) || entry.existsIn(temporalDirectory)) continue;
                    try {
                        entry.getArtifacts(temporalDirectory).forEach(arg_0 -> ((InstallRequest)installRequest).addArtifact(arg_0));
                    }
                    catch (IOException e) {
                        if ("org/ow2/sat4j/org.ow2.sat4j.pom".equals(entry.getEntryPath())) continue;
                        MuleCorePlugin.logError("There was a problem copying maven artifacts to temp directory. Entry: " + String.valueOf(entry) + ". Directory: " + String.valueOf(temporalDirectory), e);
                    }
                }
                if (!installRequest.getArtifacts().isEmpty()) {
                    this.backupUnknownMetadataFiles(entries, destRepository);
                    this.doInstall(installRequest, destRepository);
                }
            }
            catch (Throwable e) {
                MuleCorePlugin.logError("Installing prepackaged Maven repository artifacts failed: " + e.getMessage(), e);
                FileUtils.deleteQuietly((File)temporalDirectory);
            }
        }
        finally {
            FileUtils.deleteQuietly((File)temporalDirectory);
        }
    }

    private void backupUnknownMetadataFiles(Collection<MavenRepositoryEntry> entries, File destRepository) {
        for (MavenRepositoryEntry entry : entries) {
            RemoteRepositoriesMetadata remoteRepositoryMetadata;
            if (!entry.existsIn(destRepository) || (remoteRepositoryMetadata = entry.getRemoteRepositoryMetadata(destRepository)).isMetadataFormatValid()) continue;
            remoteRepositoryMetadata.backup();
        }
    }

    private void doInstall(InstallRequest installRequest, File destRepository) throws InstallationException {
        RepositorySystem system = Booter.newRepositorySystem();
        DefaultRepositorySystemSession session = Booter.newRepositorySystemSession(system, destRepository.getAbsolutePath(), Booter.RepositoryType.ENHANCED, Booter.UpdatePolicy.NEVER, true);
        system.install((RepositorySystemSession)session, installRequest);
        system.shutdown();
    }

    public Collection<MavenRepositoryEntry> getEntries() {
        Enumeration<URL> entryUrls = this.packagingStrategy.getEntryUrls(MavenRepositoryEntry.ARTIFACT_EXTENSIONS);
        return this.collectEntries(entryUrls, this.basePath);
    }

    private List<MavenRepositoryEntry> collectEntries(Enumeration<URL> entries, String basePath) {
        HashMap<String, Set> collectedPaths = new HashMap<String, Set>();
        if (entries != null) {
            int basePathLength = basePath.length();
            while (entries.hasMoreElements()) {
                URL entryUrl = entries.nextElement();
                String entryPath = entryUrl.getPath();
                int lastSeparatorIndex = entryPath.lastIndexOf(47);
                String entryBasePath = entryPath.substring(basePathLength, lastSeparatorIndex);
                Set fileNames = collectedPaths.computeIfAbsent(entryBasePath, _x -> new HashSet());
                String fileName = this.packagingStrategy.getFileName(entryUrl);
                fileNames.add(fileName);
            }
        }
        return collectedPaths.entrySet().stream().map(entry -> this.packagingStrategy.createEntry((String)entry.getKey(), (Set)entry.getValue())).collect(Collectors.toList());
    }
}

